/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.VirtualMachineRunCommandUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.RunCommandDocumentBaseInner;
import com.microsoft.azure.management.compute.implementation.RunCommandDocumentInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineRunCommandInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineRunCommandsInner {
    private VirtualMachineRunCommandsService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineRunCommandsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineRunCommandsService)retrofit.create(VirtualMachineRunCommandsService.class);
        this.client = client;
    }

    public PagedList<RunCommandDocumentBaseInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>((Page)response.body()){

            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunCommandDocumentBaseInner>> listAsync(String location, ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunCommandDocumentBaseInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>(){

            public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.list(location, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RunCommandDocumentInner get(String location, String commandId) {
        return (RunCommandDocumentInner)((ServiceResponse)this.getWithServiceResponseAsync(location, commandId).toBlocking().single()).body();
    }

    public ServiceFuture<RunCommandDocumentInner> getAsync(String location, String commandId, ServiceCallback<RunCommandDocumentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(location, commandId), serviceCallback);
    }

    public Observable<RunCommandDocumentInner> getAsync(String location, String commandId) {
        return this.getWithServiceResponseAsync(location, commandId).map((Func1)new Func1<ServiceResponse<RunCommandDocumentInner>, RunCommandDocumentInner>(){

            public RunCommandDocumentInner call(ServiceResponse<RunCommandDocumentInner> response) {
                return (RunCommandDocumentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RunCommandDocumentInner>> getWithServiceResponseAsync(String location, String commandId) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Parameter commandId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.get(location, commandId, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunCommandDocumentInner>>>(){

            public Observable<ServiceResponse<RunCommandDocumentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RunCommandDocumentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RunCommandDocumentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)((Object)runCommand));
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>(){}.getType());
    }

    public VirtualMachineRunCommandInner beginCreateOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)((Object)runCommand));
        String apiVersion = "2020-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).register(201, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.updateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> updateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)runCommand);
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineRunCommandInner>(){}.getType());
    }

    public VirtualMachineRunCommandInner beginUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, runCommand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (runCommand == null) {
            throw new IllegalArgumentException("Parameter runCommand is required and cannot be null.");
        }
        Validator.validate((Object)runCommand);
        String apiVersion = "2020-12-01";
        return this.service.beginUpdate(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), runCommand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vmName, String runCommandName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String vmName, String runCommandName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginDelete(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName) {
        return this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.getByVirtualMachine(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.getByVirtualMachineDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName, String expand) {
        return (VirtualMachineRunCommandInner)((Object)((ServiceResponse)this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, String expand, ServiceCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand), serviceCallback);
    }

    public Observable<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName, String expand) {
        return this.getByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, runCommandName, expand).map((Func1)new Func1<ServiceResponse<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner>(){

            public VirtualMachineRunCommandInner call(ServiceResponse<VirtualMachineRunCommandInner> response) {
                return (VirtualMachineRunCommandInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineRunCommandInner>> getByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName, String runCommandName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (runCommandName == null) {
            throw new IllegalArgumentException("Parameter runCommandName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.getByVirtualMachine(resourceGroupName, vmName, runCommandName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineRunCommandInner>>>(){

            public Observable<ServiceResponse<VirtualMachineRunCommandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineRunCommandsInner.this.getByVirtualMachineDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineRunCommandInner> getByVirtualMachineDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineRunCommandInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName) {
        ServiceResponse response = (ServiceResponse)this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(String resourceGroupName, String vmName, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(String resourceGroupName, String vmName) {
        return this.listByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName) {
        return this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.listByVirtualMachine(resourceGroupName, vmName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listByVirtualMachineDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName, String expand) {
        ServiceResponse response = (ServiceResponse)this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(String resourceGroupName, String vmName, String expand, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineAsync(String resourceGroupName, String vmName, String expand) {
        return this.listByVirtualMachineWithServiceResponseAsync(resourceGroupName, vmName, expand).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineWithServiceResponseAsync(String resourceGroupName, String vmName, String expand) {
        return this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listByVirtualMachine(resourceGroupName, vmName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listByVirtualMachineDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listByVirtualMachineDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RunCommandDocumentBaseInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RunCommandDocumentBaseInner>((Page)response.body()){

            public Page<RunCommandDocumentBaseInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunCommandDocumentBaseInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RunCommandDocumentBaseInner>> serviceFuture, ListOperationCallback<RunCommandDocumentBaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunCommandDocumentBaseInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Page<RunCommandDocumentBaseInner>>(){

            public Page<RunCommandDocumentBaseInner> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RunCommandDocumentBaseInner>>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(ServiceResponse<Page<RunCommandDocumentBaseInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>>>(){

            public Observable<ServiceResponse<Page<RunCommandDocumentBaseInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RunCommandDocumentBaseInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RunCommandDocumentBaseInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineRunCommandInner> listByVirtualMachineNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineRunCommandInner>((Page)response.body()){

            public Page<VirtualMachineRunCommandInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineRunCommandInner>> listByVirtualMachineNextAsync(String nextPageLink, ServiceFuture<List<VirtualMachineRunCommandInner>> serviceFuture, ListOperationCallback<VirtualMachineRunCommandInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVirtualMachineNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(String nextPageLink) {
                return VirtualMachineRunCommandsInner.this.listByVirtualMachineNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineRunCommandInner>> listByVirtualMachineNextAsync(String nextPageLink) {
        return this.listByVirtualMachineNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Page<VirtualMachineRunCommandInner>>(){

            public Page<VirtualMachineRunCommandInner> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVirtualMachineNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineRunCommandInner>>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(ServiceResponse<Page<VirtualMachineRunCommandInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachineRunCommandsInner.this.listByVirtualMachineNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> listByVirtualMachineNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVirtualMachineNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineRunCommandInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachineRunCommandsInner.this.listByVirtualMachineNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineRunCommandInner>> listByVirtualMachineNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineRunCommandInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineRunCommandsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}")
        public Observable<Response<ResponseBody>> get(@Path(value="location") String var1, @Path(value="commandId") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualMachineRunCommandInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualMachineRunCommandInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualMachineRunCommandUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualMachineRunCommandUpdate var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands getByVirtualMachine"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        public Observable<Response<ResponseBody>> getByVirtualMachine(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="runCommandName") String var3, @Path(value="subscriptionId") String var4, @Query(value="$expand") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listByVirtualMachine"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands")
        public Observable<Response<ResponseBody>> listByVirtualMachine(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$expand") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineRunCommands listByVirtualMachineNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVirtualMachineNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

