/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.google.common.base.Strings;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.management.compute.DiskVolumeType;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.Objects;

public abstract class VirtualMachineEncryptionConfiguration<T extends VirtualMachineEncryptionConfiguration<T>> {
    protected final String keyVaultId;
    protected final String aadClientId;
    protected final String aadSecret;
    protected DiskVolumeType volumeType = DiskVolumeType.ALL;
    protected String keyEncryptionKeyURL;
    protected String keyEncryptionKeyVaultId;
    protected String encryptionAlgorithm = "RSA-OAEP";
    protected String passPhrase;
    protected final AzureEnvironment azureEnvironment;
    protected final String vaultUri;

    protected VirtualMachineEncryptionConfiguration(String keyVaultId, String vaultUri, String aadClientId, String aadSecret, AzureEnvironment azureEnvironment) {
        this.keyVaultId = Objects.requireNonNull(keyVaultId, "KeyVaultId parameter holding resource id of the KeyVault to store disk encryption key is required.");
        this.aadClientId = Objects.requireNonNull(aadClientId, "aadClientId parameter holding AAD client id to access the KeyVault is required.");
        this.aadSecret = Objects.requireNonNull(aadSecret, "aadSecret parameter holding AAD secret to access the KeyVault is required.");
        this.vaultUri = vaultUri;
        this.azureEnvironment = azureEnvironment;
    }

    protected VirtualMachineEncryptionConfiguration(String keyVaultId, String vaultUri, AzureEnvironment azureEnvironment) {
        this.keyVaultId = Objects.requireNonNull(keyVaultId, "KeyVaultId parameter holding resource id of the keyVault to store disk encryption key is required.");
        this.aadClientId = null;
        this.aadSecret = null;
        this.vaultUri = vaultUri;
        this.azureEnvironment = azureEnvironment;
    }

    public abstract OperatingSystemTypes osType();

    public String aadClientId() {
        return this.aadClientId;
    }

    public String aadSecret() {
        return this.aadSecret;
    }

    public DiskVolumeType volumeType() {
        if (this.volumeType != null) {
            return this.volumeType;
        }
        return DiskVolumeType.ALL;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public String keyVaultUrl() {
        String keyVaultDnsSuffix;
        if (this.vaultUri != null) {
            return this.vaultUri;
        }
        if (this.azureEnvironment != null && !Strings.isNullOrEmpty((String)this.azureEnvironment.keyVaultDnsSuffix())) {
            keyVaultDnsSuffix = this.azureEnvironment.keyVaultDnsSuffix();
            if (this.azureEnvironment.managementEndpoint() != null && !AzureEnvironment.AZURE.managementEndpoint().equals(this.azureEnvironment.managementEndpoint()) && AzureEnvironment.AZURE.keyVaultDnsSuffix().equals(this.azureEnvironment.keyVaultDnsSuffix())) {
                if (AzureEnvironment.AZURE_CHINA.managementEndpoint().equals(this.azureEnvironment.managementEndpoint())) {
                    keyVaultDnsSuffix = AzureEnvironment.AZURE_CHINA.keyVaultDnsSuffix();
                } else if (AzureEnvironment.AZURE_GERMANY.managementEndpoint().equals(this.azureEnvironment.managementEndpoint())) {
                    keyVaultDnsSuffix = AzureEnvironment.AZURE_GERMANY.keyVaultDnsSuffix();
                } else if (AzureEnvironment.AZURE_US_GOVERNMENT.managementEndpoint().equals(this.azureEnvironment.managementEndpoint())) {
                    keyVaultDnsSuffix = AzureEnvironment.AZURE_US_GOVERNMENT.keyVaultDnsSuffix();
                }
            }
        } else {
            keyVaultDnsSuffix = AzureEnvironment.AZURE.keyVaultDnsSuffix();
        }
        String keyVaultName = ResourceUtils.nameFromResourceId((String)this.keyVaultId);
        return String.format("https://%1$s%2$s", keyVaultName.toLowerCase(), keyVaultDnsSuffix);
    }

    public String keyEncryptionKeyVaultId() {
        return this.keyEncryptionKeyVaultId;
    }

    public String keyEncryptionKeyURL() {
        return this.keyEncryptionKeyURL;
    }

    public String volumeEncryptionKeyEncryptAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String linuxPassPhrase() {
        return this.passPhrase;
    }

    public T withVolumeType(DiskVolumeType volumeType) {
        this.volumeType = volumeType;
        return (T)this;
    }

    public T withVolumeEncryptionKeyEncrypted(String keyEncryptionKeyURL) {
        return this.withVolumeEncryptionKeyEncrypted(keyEncryptionKeyURL, null);
    }

    public T withVolumeEncryptionKeyEncrypted(String keyEncryptionKeyURL, String keyEncryptionKeyKevVaultId) {
        this.keyEncryptionKeyURL = keyEncryptionKeyURL;
        this.keyEncryptionKeyVaultId = keyEncryptionKeyKevVaultId;
        return (T)this;
    }

    public T withVolumeEncryptionKeyEncryptAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return (T)this;
    }
}

