/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.DataDisk;
import com.microsoft.azure.management.compute.DiskCreateOptionTypes;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineUnmanagedDataDisk;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@LangDefinition
class UnmanagedDataDiskImpl
extends ChildResourceImpl<DataDisk, VirtualMachineImpl, VirtualMachine>
implements VirtualMachineUnmanagedDataDisk,
VirtualMachineUnmanagedDataDisk.DefinitionWithExistingVhd<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.DefinitionWithNewVhd<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.DefinitionWithImage<VirtualMachine.DefinitionStages.WithUnmanagedCreate>,
VirtualMachineUnmanagedDataDisk.UpdateDefinitionWithExistingVhd<VirtualMachine.Update>,
VirtualMachineUnmanagedDataDisk.UpdateDefinitionWithNewVhd<VirtualMachine.Update>,
VirtualMachineUnmanagedDataDisk.Update {
    protected UnmanagedDataDiskImpl(DataDisk inner, VirtualMachineImpl parent) {
        super((Object)inner, (Object)parent);
    }

    protected static UnmanagedDataDiskImpl prepareDataDisk(String name, VirtualMachineImpl parent) {
        DataDisk dataDiskInner = new DataDisk();
        dataDiskInner.withLun(-1).withName(name).withVhd(null);
        return new UnmanagedDataDiskImpl(dataDiskInner, parent);
    }

    public String name() {
        return ((DataDisk)this.inner()).name();
    }

    @Override
    public int size() {
        return Utils.toPrimitiveInt((Integer)((DataDisk)this.inner()).diskSizeGB());
    }

    @Override
    public int lun() {
        return Utils.toPrimitiveInt((Integer)((DataDisk)this.inner()).lun());
    }

    @Override
    public String vhdUri() {
        return ((DataDisk)this.inner()).vhd().uri();
    }

    @Override
    public CachingTypes cachingType() {
        return ((DataDisk)this.inner()).caching();
    }

    @Override
    public String sourceImageUri() {
        if (((DataDisk)this.inner()).image() != null) {
            return ((DataDisk)this.inner()).image().uri();
        }
        return null;
    }

    @Override
    public DiskCreateOptionTypes creationMethod() {
        return ((DataDisk)this.inner()).createOption();
    }

    public UnmanagedDataDiskImpl withNewVhd(int sizeInGB) {
        ((DataDisk)this.inner()).withCreateOption(DiskCreateOptionTypes.EMPTY).withDiskSizeGB(sizeInGB);
        return this;
    }

    public UnmanagedDataDiskImpl withExistingVhd(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.inner()).withCreateOption(DiskCreateOptionTypes.ATTACH).withVhd(new VirtualHardDisk().withUri(this.blobUrl(storageAccountName, containerName, vhdName)));
        return this;
    }

    public UnmanagedDataDiskImpl fromImage(int imageLun) {
        ((DataDisk)this.inner()).withCreateOption(DiskCreateOptionTypes.FROM_IMAGE).withLun(imageLun);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withSizeInGB(Integer sizeInGB) {
        ((DataDisk)this.inner()).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withLun(Integer lun) {
        ((DataDisk)this.inner()).withLun(lun);
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl withCaching(CachingTypes cachingType) {
        ((DataDisk)this.inner()).withCaching(cachingType);
        return this;
    }

    public UnmanagedDataDiskImpl storeAt(String storageAccountName, String containerName, String vhdName) {
        ((DataDisk)this.inner()).withVhd(new VirtualHardDisk());
        ((DataDisk)this.inner()).vhd().withUri(this.blobUrl(storageAccountName, containerName, vhdName));
        return this;
    }

    public VirtualMachineImpl attach() {
        return ((VirtualMachineImpl)this.parent()).withUnmanagedDataDisk(this);
    }

    protected static void setDataDisksDefaults(List<VirtualMachineUnmanagedDataDisk> dataDisks, String namePrefix) {
        ArrayList<Integer> usedLuns = new ArrayList<Integer>();
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) continue;
            usedLuns.add(dataDisk.lun());
        }
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.lun() == -1) {
                Integer i = 0;
                while (usedLuns.contains(i)) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                ((DataDisk)dataDisk.inner()).withLun(i);
                usedLuns.add(i);
            }
            if (dataDisk.name() == null) {
                ((DataDisk)dataDisk.inner()).withName(namePrefix + "-data-disk-" + dataDisk.lun());
            }
            if (((DataDisk)dataDisk.inner()).caching() != null) continue;
            ((DataDisk)dataDisk.inner()).withCaching(CachingTypes.READ_WRITE);
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineUnmanagedDataDisk> dataDisks, StorageAccount storageAccount, String namePrefix) {
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY && dataDisk.creationMethod() != DiskCreateOptionTypes.FROM_IMAGE || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
            ((DataDisk)dataDisk.inner()).withVhd(new VirtualHardDisk());
            ((DataDisk)dataDisk.inner()).vhd().withUri(storageAccount.endPoints().primary().blob() + "vhds/" + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
        }
    }

    protected static void ensureDisksVhdUri(List<VirtualMachineUnmanagedDataDisk> dataDisks, String namePrefix) {
        String containerUrl = null;
        for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() == null) continue;
            int idx = ((DataDisk)dataDisk.inner()).vhd().uri().lastIndexOf(47);
            containerUrl = ((DataDisk)dataDisk.inner()).vhd().uri().substring(0, idx);
            break;
        }
        if (containerUrl != null) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : dataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY || ((DataDisk)dataDisk.inner()).vhd() != null) continue;
                ((DataDisk)dataDisk.inner()).withVhd(new VirtualHardDisk());
                ((DataDisk)dataDisk.inner()).vhd().withUri(containerUrl + namePrefix + "-data-disk-" + dataDisk.lun() + "-" + UUID.randomUUID().toString() + ".vhd");
            }
        }
    }

    private String blobUrl(String storageAccountName, String containerName, String blobName) {
        AzureEnvironment azureEnvironment = ((VirtualMachineImpl)this.parent()).environment();
        return "https://" + storageAccountName + ".blob" + azureEnvironment.storageEndpointSuffix() + "/" + containerName + "/" + blobName;
    }
}

