/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineExtensionsImpl
extends ExternalChildResourcesCachedImpl<VirtualMachineExtensionImpl, VirtualMachineExtension, VirtualMachineExtensionInner, VirtualMachineImpl, VirtualMachine> {
    private final VirtualMachineExtensionsInner client;

    VirtualMachineExtensionsImpl(VirtualMachineExtensionsInner client, VirtualMachineImpl parent) {
        super((Object)parent, parent.taskGroup(), "VirtualMachineExtension");
        this.client = client;
        this.cacheCollection();
    }

    public Map<String, VirtualMachineExtension> asMap() {
        return Collections.unmodifiableMap((Map)this.asMapAsync().toBlocking().last());
    }

    public Observable<Map<String, VirtualMachineExtension>> asMapAsync() {
        return this.listAsync().collect((Func0)new Func0<Map<String, VirtualMachineExtension>>(){

            public Map<String, VirtualMachineExtension> call() {
                return new HashMap<String, VirtualMachineExtension>();
            }
        }, (Action2)new Action2<Map<String, VirtualMachineExtension>, VirtualMachineExtension>(){

            public void call(Map<String, VirtualMachineExtension> map, VirtualMachineExtension extension) {
                map.put(extension.name(), extension);
            }
        });
    }

    public Observable<VirtualMachineExtension> listAsync() {
        Observable extensions = Observable.from(this.collection().values());
        Observable resolvedExtensionsStream = extensions.filter((Func1)new Func1<VirtualMachineExtensionImpl, Boolean>(){

            public Boolean call(VirtualMachineExtensionImpl extension) {
                return extension.isReference();
            }
        }).flatMap((Func1)new Func1<VirtualMachineExtensionImpl, Observable<VirtualMachineExtension>>(){

            public Observable<VirtualMachineExtension> call(final VirtualMachineExtensionImpl extension) {
                return VirtualMachineExtensionsImpl.this.client.getAsync(((VirtualMachineImpl)VirtualMachineExtensionsImpl.this.parent()).resourceGroupName(), ((VirtualMachineImpl)VirtualMachineExtensionsImpl.this.parent()).name(), extension.name()).flatMap((Func1)new Func1<VirtualMachineExtensionInner, Observable<VirtualMachineExtension>>(){

                    public Observable<VirtualMachineExtension> call(VirtualMachineExtensionInner extensionInner) {
                        if (extensionInner == null) {
                            return Observable.empty();
                        }
                        return Observable.just((Object)new VirtualMachineExtensionImpl(extension.name(), (VirtualMachineImpl)VirtualMachineExtensionsImpl.this.parent(), extensionInner, VirtualMachineExtensionsImpl.this.client));
                    }
                });
            }
        });
        return resolvedExtensionsStream.concatWith(extensions.filter((Func1)new Func1<VirtualMachineExtensionImpl, Boolean>(){

            public Boolean call(VirtualMachineExtensionImpl extension) {
                return !extension.isReference();
            }
        }));
    }

    public VirtualMachineExtensionImpl define(String name) {
        VirtualMachineExtensionImpl newExtension = (VirtualMachineExtensionImpl)this.prepareInlineDefine(name);
        return newExtension;
    }

    public VirtualMachineExtensionImpl update(String name) {
        return (VirtualMachineExtensionImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addExtension(VirtualMachineExtensionImpl extension) {
        this.addChildResource(extension);
    }

    protected List<VirtualMachineExtensionImpl> listChildResources() {
        ArrayList<VirtualMachineExtensionImpl> childResources = new ArrayList<VirtualMachineExtensionImpl>();
        if (((VirtualMachineInner)((Object)((VirtualMachineImpl)this.parent()).inner())).resources() != null) {
            for (VirtualMachineExtensionInner inner : ((VirtualMachineInner)((Object)((VirtualMachineImpl)this.parent()).inner())).resources()) {
                if (inner.name() == null) {
                    inner.withLocation(((VirtualMachineImpl)this.parent()).regionName());
                    childResources.add(new VirtualMachineExtensionImpl(ResourceUtils.nameFromResourceId((String)inner.id()), (VirtualMachineImpl)this.parent(), inner, this.client));
                    continue;
                }
                childResources.add(new VirtualMachineExtensionImpl(inner.name(), (VirtualMachineImpl)this.parent(), inner, this.client));
            }
        }
        return childResources;
    }

    protected VirtualMachineExtensionImpl newChildResource(String name) {
        VirtualMachineExtensionImpl extension = VirtualMachineExtensionImpl.newVirtualMachineExtension(name, (VirtualMachineImpl)this.parent(), this.client);
        return extension;
    }
}

