/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ContainerGroupsInner
implements InnerSupportsGet<ContainerGroupInner>,
InnerSupportsDelete<ContainerGroupInner>,
InnerSupportsListing<ContainerGroupInner> {
    private ContainerGroupsService service;
    private ContainerInstanceManagementClientImpl client;

    public ContainerGroupsInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = (ContainerGroupsService)retrofit.create(ContainerGroupsService.class);
        this.client = client;
    }

    public PagedList<ContainerGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ContainerGroupInner>((Page)response.body()){

            public Page<ContainerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerGroupInner>> listAsync(ListOperationCallback<ContainerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(String nextPageLink) {
                return ContainerGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Page<ContainerGroupInner>>(){

            public Page<ContainerGroupInner> call(ServiceResponse<Page<ContainerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(ServiceResponse<Page<ContainerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerGroupInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ContainerGroupInner>((Page)response.body()){

            public Page<ContainerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerGroupInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ContainerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(String nextPageLink) {
                return ContainerGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerGroupInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Page<ContainerGroupInner>>(){

            public Page<ContainerGroupInner> call(ServiceResponse<Page<ContainerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(ServiceResponse<Page<ContainerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerGroupInner getByResourceGroup(String resourceGroupName, String containerGroupName) {
        return (ContainerGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerGroupInner> getByResourceGroupAsync(String resourceGroupName, String containerGroupName, ServiceCallback<ContainerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerGroupName), serviceCallback);
    }

    public Observable<ContainerGroupInner> getByResourceGroupAsync(String resourceGroupName, String containerGroupName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, containerGroupName).map((Func1)new Func1<ServiceResponse<ContainerGroupInner>, ContainerGroupInner>(){

            public ContainerGroupInner call(ServiceResponse<ContainerGroupInner> response) {
                return (ContainerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String containerGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, containerGroupName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerGroupInner>>>(){

            public Observable<ServiceResponse<ContainerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerGroupInner createOrUpdate(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        return (ContainerGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup).toBlocking().last()).body());
    }

    public ServiceFuture<ContainerGroupInner> createOrUpdateAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup, ServiceCallback<ContainerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup), serviceCallback);
    }

    public Observable<ContainerGroupInner> createOrUpdateAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup).map((Func1)new Func1<ServiceResponse<ContainerGroupInner>, ContainerGroupInner>(){

            public ContainerGroupInner call(ServiceResponse<ContainerGroupInner> response) {
                return (ContainerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (containerGroup == null) {
            throw new IllegalArgumentException("Parameter containerGroup is required and cannot be null.");
        }
        Validator.validate((Object)((Object)containerGroup));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, containerGroupName, this.client.apiVersion(), containerGroup, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ContainerGroupInner>(){}.getType());
    }

    public ContainerGroupInner beginCreateOrUpdate(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        return (ContainerGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup, ServiceCallback<ContainerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup), serviceCallback);
    }

    public Observable<ContainerGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, containerGroupName, containerGroup).map((Func1)new Func1<ServiceResponse<ContainerGroupInner>, ContainerGroupInner>(){

            public ContainerGroupInner call(ServiceResponse<ContainerGroupInner> response) {
                return (ContainerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (containerGroup == null) {
            throw new IllegalArgumentException("Parameter containerGroup is required and cannot be null.");
        }
        Validator.validate((Object)((Object)containerGroup));
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, containerGroupName, this.client.apiVersion(), containerGroup, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerGroupInner>>>(){

            public Observable<ServiceResponse<ContainerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerGroupInner>(){}.getType()).register(201, new TypeToken<ContainerGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerGroupInner update(String resourceGroupName, String containerGroupName, Resource resource) {
        return (ContainerGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, containerGroupName, resource).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerGroupInner> updateAsync(String resourceGroupName, String containerGroupName, Resource resource, ServiceCallback<ContainerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, containerGroupName, resource), serviceCallback);
    }

    public Observable<ContainerGroupInner> updateAsync(String resourceGroupName, String containerGroupName, Resource resource) {
        return this.updateWithServiceResponseAsync(resourceGroupName, containerGroupName, resource).map((Func1)new Func1<ServiceResponse<ContainerGroupInner>, ContainerGroupInner>(){

            public ContainerGroupInner call(ServiceResponse<ContainerGroupInner> response) {
                return (ContainerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String containerGroupName, Resource resource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Parameter resource is required and cannot be null.");
        }
        Validator.validate((Object)resource);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, containerGroupName, this.client.apiVersion(), resource, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerGroupInner>>>(){

            public Observable<ServiceResponse<ContainerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ContainerGroupInner delete(String resourceGroupName, String containerGroupName) {
        return (ContainerGroupInner)((Object)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, containerGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ContainerGroupInner> deleteAsync(String resourceGroupName, String containerGroupName, ServiceCallback<ContainerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, containerGroupName), serviceCallback);
    }

    public Observable<ContainerGroupInner> deleteAsync(String resourceGroupName, String containerGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, containerGroupName).map((Func1)new Func1<ServiceResponse<ContainerGroupInner>, ContainerGroupInner>(){

            public ContainerGroupInner call(ServiceResponse<ContainerGroupInner> response) {
                return (ContainerGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ContainerGroupInner>> deleteWithServiceResponseAsync(String resourceGroupName, String containerGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, containerGroupName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerGroupInner>>>(){

            public Observable<ServiceResponse<ContainerGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ContainerGroupInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ContainerGroupInner>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ContainerGroupInner>((Page)response.body()){

            public Page<ContainerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ContainerGroupInner>> serviceFuture, ListOperationCallback<ContainerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(String nextPageLink) {
                return ContainerGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Page<ContainerGroupInner>>(){

            public Page<ContainerGroupInner> call(ServiceResponse<Page<ContainerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(ServiceResponse<Page<ContainerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ContainerGroupInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ContainerGroupInner>((Page)response.body()){

            public Page<ContainerGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ContainerGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ContainerGroupInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ContainerGroupInner>> serviceFuture, ListOperationCallback<ContainerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(String nextPageLink) {
                return ContainerGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ContainerGroupInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Page<ContainerGroupInner>>(){

            public Page<ContainerGroupInner> call(ServiceResponse<Page<ContainerGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ContainerGroupInner>>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(ServiceResponse<Page<ContainerGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ContainerGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ContainerGroupInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContainerGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ContainerGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ContainerGroupsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ContainerGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ContainerGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ContainerGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/containerGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Query(value="api-version") String var4, @Body ContainerGroupInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Query(value="api-version") String var4, @Body ContainerGroupInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Query(value="api-version") String var4, @Body Resource var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="containerGroupName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroups listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

