/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.management.containerinstance.ContainerExecRequestTerminalSize;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The container exec request.
 */
public class ContainerExecRequestInner {
    /**
     * The command to be executed.
     */
    @JsonProperty(value = "command")
    private String command;

    /**
     * The size of the terminal.
     */
    @JsonProperty(value = "terminalSize")
    private ContainerExecRequestTerminalSize terminalSize;

    /**
     * Get the command value.
     *
     * @return the command value
     */
    public String command() {
        return this.command;
    }

    /**
     * Set the command value.
     *
     * @param command the command value to set
     * @return the ContainerExecRequestInner object itself.
     */
    public ContainerExecRequestInner withCommand(String command) {
        this.command = command;
        return this;
    }

    /**
     * Get the terminalSize value.
     *
     * @return the terminalSize value
     */
    public ContainerExecRequestTerminalSize terminalSize() {
        return this.terminalSize;
    }

    /**
     * Set the terminalSize value.
     *
     * @param terminalSize the terminalSize value to set
     * @return the ContainerExecRequestInner object itself.
     */
    public ContainerExecRequestInner withTerminalSize(ContainerExecRequestTerminalSize terminalSize) {
        this.terminalSize = terminalSize;
        return this;
    }

}
