/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in StartContainers.
 */
public class StartContainersInner {
    /** The Retrofit service to perform REST calls. */
    private StartContainersService service;
    /** The service client containing this operation class. */
    private ContainerInstanceManagementClientImpl client;

    /**
     * Initializes an instance of StartContainersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public StartContainersInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = retrofit.create(StartContainersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for StartContainers to be
     * used by Retrofit to perform actually REST calls.
     */
    interface StartContainersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.StartContainers launchExec" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        Observable<Response<ResponseBody>> launchExec(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("containerGroupName") String containerGroupName, @Path("containerName") String containerName, @Query("api-version") String apiVersion, @Body ContainerExecRequestInner containerExecRequest, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Starts the exec command for a specific container instance.
     * Starts the exec command for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ContainerExecResponseInner object if successful.
     */
    public ContainerExecResponseInner launchExec(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        return launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).toBlocking().single().body();
    }

    /**
     * Starts the exec command for a specific container instance.
     * Starts the exec command for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ContainerExecResponseInner> launchExecAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest, final ServiceCallback<ContainerExecResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest), serviceCallback);
    }

    /**
     * Starts the exec command for a specific container instance.
     * Starts the exec command for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContainerExecResponseInner object
     */
    public Observable<ContainerExecResponseInner> launchExecAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        return launchExecWithServiceResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).map(new Func1<ServiceResponse<ContainerExecResponseInner>, ContainerExecResponseInner>() {
            @Override
            public ContainerExecResponseInner call(ServiceResponse<ContainerExecResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Starts the exec command for a specific container instance.
     * Starts the exec command for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContainerExecResponseInner object
     */
    public Observable<ServiceResponse<ContainerExecResponseInner>> launchExecWithServiceResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequestInner containerExecRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (containerGroupName == null) {
            throw new IllegalArgumentException("Parameter containerGroupName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (containerExecRequest == null) {
            throw new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null.");
        }
        Validator.validate(containerExecRequest);
        return service.launchExec(this.client.subscriptionId(), resourceGroupName, containerGroupName, containerName, this.client.apiVersion(), containerExecRequest, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContainerExecResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<ContainerExecResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ContainerExecResponseInner> clientResponse = launchExecDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ContainerExecResponseInner> launchExecDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ContainerExecResponseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ContainerExecResponseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
