/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The port.
 */
public class Port {
    /**
     * The protocol associated with the port. Possible values include: 'TCP',
     * 'UDP'.
     */
    @JsonProperty(value = "protocol")
    private ContainerGroupNetworkProtocol protocol;

    /**
     * The port.
     */
    @JsonProperty(value = "port", required = true)
    private int port;

    /**
     * Get the protocol value.
     *
     * @return the protocol value
     */
    public ContainerGroupNetworkProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol value.
     *
     * @param protocol the protocol value to set
     * @return the Port object itself.
     */
    public Port withProtocol(ContainerGroupNetworkProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the port value.
     *
     * @return the port value
     */
    public int port() {
        return this.port;
    }

    /**
     * Set the port value.
     *
     * @param port the port value to set
     * @return the Port object itself.
     */
    public Port withPort(int port) {
        this.port = port;
        return this;
    }

}
