/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The volume mount.
 */
public class VolumeMount {
    /**
     * The volume mount name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The path with in the container at which the volume should be mounted.
     * Must not contain ':'.
     */
    @JsonProperty(value = "mountPath", required = true)
    private String mountPath;

    /**
     * The flag indicating whether the volume mount is read only.
     */
    @JsonProperty(value = "readOnly")
    private Boolean readOnly;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the VolumeMount object itself.
     */
    public VolumeMount withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the mountPath value.
     *
     * @return the mountPath value
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath value.
     *
     * @param mountPath the mountPath value to set
     * @return the VolumeMount object itself.
     */
    public VolumeMount withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Get the readOnly value.
     *
     * @return the readOnly value
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly value.
     *
     * @param readOnly the readOnly value to set
     * @return the VolumeMount object itself.
     */
    public VolumeMount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

}
