/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance.implementation;

import java.util.List;
import com.microsoft.azure.management.containerinstance.CachedImages;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The response containing cached images.
 */
public class CachedImagesListResultInner {
    /**
     * The list of cached images.
     */
    @JsonProperty(value = "value")
    private List<CachedImages> value;

    /**
     * The URI to fetch the next page of cached images.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the list of cached images.
     *
     * @return the value value
     */
    public List<CachedImages> value() {
        return this.value;
    }

    /**
     * Set the list of cached images.
     *
     * @param value the value value to set
     * @return the CachedImagesListResultInner object itself.
     */
    public CachedImagesListResultInner withValue(List<CachedImages> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the URI to fetch the next page of cached images.
     *
     * @return the nextLink value
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the URI to fetch the next page of cached images.
     *
     * @param nextLink the nextLink value to set
     * @return the CachedImagesListResultInner object itself.
     */
    public CachedImagesListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

}
