/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The container instance state.
 */
public class ContainerState {
    /**
     * The state of the container instance.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /**
     * The date-time when the container instance state started.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime startTime;

    /**
     * The container instance exit codes correspond to those from the `docker
     * run` command.
     */
    @JsonProperty(value = "exitCode", access = JsonProperty.Access.WRITE_ONLY)
    private Integer exitCode;

    /**
     * The date-time when the container instance state finished.
     */
    @JsonProperty(value = "finishTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime finishTime;

    /**
     * The human-readable status of the container instance state.
     */
    @JsonProperty(value = "detailStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String detailStatus;

    /**
     * Get the state of the container instance.
     *
     * @return the state value
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the date-time when the container instance state started.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the container instance exit codes correspond to those from the `docker run` command.
     *
     * @return the exitCode value
     */
    public Integer exitCode() {
        return this.exitCode;
    }

    /**
     * Get the date-time when the container instance state finished.
     *
     * @return the finishTime value
     */
    public DateTime finishTime() {
        return this.finishTime;
    }

    /**
     * Get the human-readable status of the container instance state.
     *
     * @return the detailStatus value
     */
    public String detailStatus() {
        return this.detailStatus;
    }

}
