/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for ContainerGroupRestartPolicy.
 */
public final class ContainerGroupRestartPolicy extends ExpandableStringEnum<ContainerGroupRestartPolicy> {
    /** Static value Always for ContainerGroupRestartPolicy. */
    public static final ContainerGroupRestartPolicy ALWAYS = fromString("Always");

    /** Static value OnFailure for ContainerGroupRestartPolicy. */
    public static final ContainerGroupRestartPolicy ON_FAILURE = fromString("OnFailure");

    /** Static value Never for ContainerGroupRestartPolicy. */
    public static final ContainerGroupRestartPolicy NEVER = fromString("Never");

    /**
     * Creates or finds a ContainerGroupRestartPolicy from its string representation.
     * @param name a name to look for
     * @return the corresponding ContainerGroupRestartPolicy
     */
    @JsonCreator
    public static ContainerGroupRestartPolicy fromString(String name) {
        return fromString(name, ContainerGroupRestartPolicy.class);
    }

    /**
     * @return known ContainerGroupRestartPolicy values
     */
    public static Collection<ContainerGroupRestartPolicy> values() {
        return values(ContainerGroupRestartPolicy.class);
    }
}
