/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The GPU resource.
 */
public class GpuResource {
    /**
     * The count of the GPU resource.
     */
    @JsonProperty(value = "count", required = true)
    private int count;

    /**
     * The SKU of the GPU resource. Possible values include: 'K80', 'P100',
     * 'V100'.
     */
    @JsonProperty(value = "sku", required = true)
    private GpuSku sku;

    /**
     * Get the count of the GPU resource.
     *
     * @return the count value
     */
    public int count() {
        return this.count;
    }

    /**
     * Set the count of the GPU resource.
     *
     * @param count the count value to set
     * @return the GpuResource object itself.
     */
    public GpuResource withCount(int count) {
        this.count = count;
        return this;
    }

    /**
     * Get the SKU of the GPU resource. Possible values include: 'K80', 'P100', 'V100'.
     *
     * @return the sku value
     */
    public GpuSku sku() {
        return this.sku;
    }

    /**
     * Set the SKU of the GPU resource. Possible values include: 'K80', 'P100', 'V100'.
     *
     * @param sku the sku value to set
     * @return the GpuResource object itself.
     */
    public GpuResource withSku(GpuSku sku) {
        this.sku = sku;
        return this;
    }

}
