/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The init container definition.
 */
@JsonFlatten
public class InitContainerDefinition {
    /**
     * The name for the init container.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The image of the init container.
     */
    @JsonProperty(value = "properties.image")
    private String image;

    /**
     * The command to execute within the init container in exec form.
     */
    @JsonProperty(value = "properties.command")
    private List<String> command;

    /**
     * The environment variables to set in the init container.
     */
    @JsonProperty(value = "properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * The instance view of the init container. Only valid in response.
     */
    @JsonProperty(value = "properties.instanceView", access = JsonProperty.Access.WRITE_ONLY)
    private InitContainerPropertiesDefinitionInstanceView instanceView;

    /**
     * The volume mounts available to the init container.
     */
    @JsonProperty(value = "properties.volumeMounts")
    private List<VolumeMount> volumeMounts;

    /**
     * Get the name for the init container.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name for the init container.
     *
     * @param name the name value to set
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the image of the init container.
     *
     * @return the image value
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image of the init container.
     *
     * @param image the image value to set
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Get the command to execute within the init container in exec form.
     *
     * @return the command value
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command to execute within the init container in exec form.
     *
     * @param command the command value to set
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Get the environment variables to set in the init container.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environment variables to set in the init container.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the instance view of the init container. Only valid in response.
     *
     * @return the instanceView value
     */
    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the volume mounts available to the init container.
     *
     * @return the volumeMounts value
     */
    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    /**
     * Set the volume mounts available to the init container.
     *
     * @param volumeMounts the volumeMounts value to set
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

}
