/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ContainerGroupUsages.
 */
public class ContainerGroupUsagesInner {
    /** The Retrofit service to perform REST calls. */
    private ContainerGroupUsagesService service;
    /** The service client containing this operation class. */
    private ContainerInstanceManagementClientImpl client;

    /**
     * Initializes an instance of ContainerGroupUsagesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ContainerGroupUsagesInner(Retrofit retrofit, ContainerInstanceManagementClientImpl client) {
        this.service = retrofit.create(ContainerGroupUsagesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerGroupUsages to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ContainerGroupUsagesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerGroupUsages list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/usages")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("location") String location, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get the usage for a subscription.
     *
     * @param location The identifier for the physical azure location.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UsageListResultInner object if successful.
     */
    public UsageListResultInner list(String location) {
        return listWithServiceResponseAsync(location).toBlocking().single().body();
    }

    /**
     * Get the usage for a subscription.
     *
     * @param location The identifier for the physical azure location.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UsageListResultInner> listAsync(String location, final ServiceCallback<UsageListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(location), serviceCallback);
    }

    /**
     * Get the usage for a subscription.
     *
     * @param location The identifier for the physical azure location.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UsageListResultInner object
     */
    public Observable<UsageListResultInner> listAsync(String location) {
        return listWithServiceResponseAsync(location).map(new Func1<ServiceResponse<UsageListResultInner>, UsageListResultInner>() {
            @Override
            public UsageListResultInner call(ServiceResponse<UsageListResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the usage for a subscription.
     *
     * @param location The identifier for the physical azure location.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UsageListResultInner object
     */
    public Observable<ServiceResponse<UsageListResultInner>> listWithServiceResponseAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UsageListResultInner>>>() {
                @Override
                public Observable<ServiceResponse<UsageListResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UsageListResultInner> clientResponse = listDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UsageListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UsageListResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<UsageListResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
