/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.AccessKeyType;
import com.microsoft.azure.management.containerregistry.CheckNameAvailabilityResult;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.Registries;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.RegistryCredentials;
import com.microsoft.azure.management.containerregistry.RegistryUsage;
import com.microsoft.azure.management.containerregistry.implementation.CheckNameAvailabilityResultImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistriesInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryCredentialsImpl;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryListCredentialsResultInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryNameStatusInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUsageListResultInner;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksClientImpl;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class RegistriesImpl
extends GroupableResourcesImpl<Registry, RegistryImpl, RegistryInner, RegistriesInner, ContainerRegistryManager>
implements Registries {
    private final StorageManager storageManager;

    protected RegistriesImpl(ContainerRegistryManager manager, StorageManager storageManager) {
        super((Object)((ContainerRegistryManagementClientImpl)((Object)manager.inner())).registries(), (ManagerBase)manager);
        this.storageManager = storageManager;
    }

    public PagedList<Registry> list() {
        final RegistriesImpl self = this;
        return new GroupPagedList<Registry>(((ContainerRegistryManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<Registry> listNextGroup(String resourceGroupName) {
                return RegistriesImpl.this.wrapList(((RegistriesInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<Registry> listAsync() {
        return ((ContainerRegistryManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<Registry>>(){

            public Observable<Registry> call(ResourceGroup resourceGroup) {
                return RegistriesImpl.this.wrapPageAsync(((RegistriesInner)RegistriesImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public Observable<Registry> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((RegistriesInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedList<Registry> listByResourceGroup(String groupName) {
        return this.wrapList(((RegistriesInner)this.inner()).listByResourceGroup(groupName));
    }

    protected Observable<RegistryInner> getInnerAsync(String resourceGroupName, String name) {
        return ((RegistriesInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public RegistryImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Completable deleteInnerAsync(String groupName, String name) {
        return ((RegistriesInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    protected RegistryImpl wrapModel(String name) {
        return new RegistryImpl(name, new RegistryInner(), (ContainerRegistryManager)this.manager(), this.storageManager);
    }

    protected RegistryImpl wrapModel(RegistryInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new RegistryImpl(containerServiceInner.name(), containerServiceInner, (ContainerRegistryManager)this.manager(), this.storageManager);
    }

    @Override
    public RegistryCredentials getCredentials(String resourceGroupName, String registryName) {
        return new RegistryCredentialsImpl(((RegistriesInner)this.inner()).listCredentials(resourceGroupName, registryName));
    }

    @Override
    public Observable<RegistryCredentials> getCredentialsAsync(String resourceGroupName, String registryName) {
        return ((RegistriesInner)this.inner()).listCredentialsAsync(resourceGroupName, registryName).map((Func1)new Func1<RegistryListCredentialsResultInner, RegistryCredentials>(){

            public RegistryCredentials call(RegistryListCredentialsResultInner registryListCredentialsResultInner) {
                return new RegistryCredentialsImpl(registryListCredentialsResultInner);
            }
        });
    }

    @Override
    public RegistryCredentials regenerateCredential(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return new RegistryCredentialsImpl(((RegistriesInner)this.inner()).regenerateCredential(resourceGroupName, registryName, PasswordName.fromString(accessKeyType.toString())));
    }

    @Override
    public Observable<RegistryCredentials> regenerateCredentialAsync(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return ((RegistriesInner)this.inner()).regenerateCredentialAsync(resourceGroupName, registryName, PasswordName.fromString(accessKeyType.toString())).map((Func1)new Func1<RegistryListCredentialsResultInner, RegistryCredentials>(){

            public RegistryCredentials call(RegistryListCredentialsResultInner registryListCredentialsResultInner) {
                return new RegistryCredentialsImpl(registryListCredentialsResultInner);
            }
        });
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages(String resourceGroupName, String registryName) {
        RegistryUsageListResultInner resultInner = ((RegistriesInner)this.inner()).listUsages(resourceGroupName, registryName);
        return Collections.unmodifiableList(resultInner != null && resultInner.value() != null ? resultInner.value() : new ArrayList());
    }

    @Override
    public Observable<RegistryUsage> listQuotaUsagesAsync(String resourceGroupName, String registryName) {
        return ((RegistriesInner)this.inner()).listUsagesAsync(resourceGroupName, registryName).flatMap((Func1)new Func1<RegistryUsageListResultInner, Observable<RegistryUsage>>(){

            public Observable<RegistryUsage> call(RegistryUsageListResultInner registryUsageListResultInner) {
                return registryUsageListResultInner.value() != null ? Observable.from(registryUsageListResultInner.value()) : null;
            }
        });
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((RegistriesInner)this.inner()).checkNameAvailability(name));
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((RegistriesInner)this.inner()).checkNameAvailabilityAsync(name).map((Func1)new Func1<RegistryNameStatusInner, CheckNameAvailabilityResult>(){

            public CheckNameAvailabilityResult call(RegistryNameStatusInner registryNameStatusInner) {
                return new CheckNameAvailabilityResultImpl(registryNameStatusInner);
            }
        });
    }

    @Override
    public Registries.WebhooksClient webhooks() {
        return new WebhooksClientImpl((ContainerRegistryManager)this.manager(), null);
    }
}

