/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.containerregistry.ReplicationUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Replications.
 */
public class ReplicationsInner {
    /** The Retrofit service to perform REST calls. */
    private ReplicationsService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of ReplicationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ReplicationsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(ReplicationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Replications to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ReplicationsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Body ReplicationInner replication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Body ReplicationInner replication, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ReplicationUpdateParameters replicationUpdateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("replicationName") String replicationName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ReplicationUpdateParameters replicationUpdateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Replications listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the properties of the specified replication.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner get(String resourceGroupName, String registryName, String replicationName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single().body();
    }

    /**
     * Gets the properties of the specified replication.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> getAsync(String resourceGroupName, String registryName, String replicationName, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    /**
     * Gets the properties of the specified replication.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ReplicationInner> getAsync(String resourceGroupName, String registryName, String replicationName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the properties of the specified replication.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ServiceResponse<ReplicationInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ReplicationInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ReplicationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ReplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ReplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner create(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).toBlocking().last().body();
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication), serviceCallback);
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ReplicationInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (replication == null) {
            throw new IllegalArgumentException("Parameter replication is required and cannot be null.");
        }
        Validator.validate(replication);
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), replication, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>() { }.getType());
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner beginCreate(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).toBlocking().single().body();
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication), serviceCallback);
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, replication).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param replication The parameters for creating a replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ServiceResponse<ReplicationInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (replication == null) {
            throw new IllegalArgumentException("Parameter replication is required and cannot be null.");
        }
        Validator.validate(replication);
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), replication, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ReplicationInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ReplicationInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ReplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ReplicationInner>() { }.getType())
                .register(201, new TypeToken<ReplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName, String replicationName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().last().body();
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName, String replicationName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single().body();
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a replication from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().last().body();
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ReplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Map<String, String> tags = null;
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>() { }.getType());
    }
    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).toBlocking().last().body();
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags), serviceCallback);
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ReplicationInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ReplicationInner>() { }.getType());
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner beginUpdate(String resourceGroupName, String registryName, String replicationName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).toBlocking().single().body();
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName), serviceCallback);
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ServiceResponse<ReplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Map<String, String> tags = null;
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(null);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ReplicationInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ReplicationInner object if successful.
     */
    public ReplicationInner beginUpdate(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).toBlocking().single().body();
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, final ServiceCallback<ReplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags), serviceCallback);
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, replicationName, tags).map(new Func1<ServiceResponse<ReplicationInner>, ReplicationInner>() {
            @Override
            public ReplicationInner call(ServiceResponse<ReplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a replication for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param tags The tags for the replication.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ReplicationInner object
     */
    public Observable<ServiceResponse<ReplicationInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (replicationName == null) {
            throw new IllegalArgumentException("Parameter replicationName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, replicationName, this.client.apiVersion(), this.client.acceptLanguage(), replicationUpdateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ReplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ReplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ReplicationInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ReplicationInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ReplicationInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ReplicationInner>() { }.getType())
                .register(201, new TypeToken<ReplicationInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ReplicationInner&gt; object if successful.
     */
    public PagedList<ReplicationInner> list(final String resourceGroupName, final String registryName) {
        ServiceResponse<Page<ReplicationInner>> response = listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<ReplicationInner>(response.body()) {
            @Override
            public Page<ReplicationInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ReplicationInner>> listAsync(final String resourceGroupName, final String registryName, final ListOperationCallback<ReplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName),
            new Func1<String, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ReplicationInner&gt; object
     */
    public Observable<Page<ReplicationInner>> listAsync(final String resourceGroupName, final String registryName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName)
            .map(new Func1<ServiceResponse<Page<ReplicationInner>>, Page<ReplicationInner>>() {
                @Override
                public Page<ReplicationInner> call(ServiceResponse<Page<ReplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ReplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<ReplicationInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName) {
        return listSinglePageAsync(resourceGroupName, registryName)
            .concatMap(new Func1<ServiceResponse<Page<ReplicationInner>>, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(ServiceResponse<Page<ReplicationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the replications for the specified container registry.
     *
    ServiceResponse<PageImpl<ReplicationInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<ReplicationInner>> * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ReplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ReplicationInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ReplicationInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ReplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ReplicationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ReplicationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ReplicationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ReplicationInner&gt; object if successful.
     */
    public PagedList<ReplicationInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ReplicationInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ReplicationInner>(response.body()) {
            @Override
            public Page<ReplicationInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ReplicationInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ReplicationInner>> serviceFuture, final ListOperationCallback<ReplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ReplicationInner&gt; object
     */
    public Observable<Page<ReplicationInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ReplicationInner>>, Page<ReplicationInner>>() {
                @Override
                public Page<ReplicationInner> call(ServiceResponse<Page<ReplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the replications for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ReplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<ReplicationInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ReplicationInner>>, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(ServiceResponse<Page<ReplicationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the replications for the specified container registry.
     *
    ServiceResponse<PageImpl<ReplicationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ReplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ReplicationInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ReplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ReplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ReplicationInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ReplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ReplicationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ReplicationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ReplicationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
