/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in WebhookOperations.
 */
public class WebhooksInner {
    /** The Retrofit service to perform REST calls. */
    private WebhooksService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of WebhooksInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public WebhooksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(WebhooksService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for WebhookOperations to be
     * used by Retrofit to perform actually REST calls.
     */
    interface WebhooksService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Body WebhookCreateParametersInner webhookCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Body WebhookCreateParametersInner webhookCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Body WebhookUpdateParametersInner webhookUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Body WebhookUpdateParametersInner webhookUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations ping" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/ping")
        Observable<Response<ResponseBody>> ping(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations getCallbackConfig" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/getCallbackConfig")
        Observable<Response<ResponseBody>> getCallbackConfig(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations listEvents" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/listEvents")
        Observable<Response<ResponseBody>> listEvents(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("webhookName") String webhookName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.WebhookOperations listEventsNext" })
        @GET
        Observable<Response<ResponseBody>> listEventsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebhookInner object if successful.
     */
    public WebhookInner get(String resourceGroupName, String registryName, String webhookName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single().body();
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName, final ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map(new Func1<ServiceResponse<WebhookInner>, WebhookInner>() {
            @Override
            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<ServiceResponse<WebhookInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>() {
                @Override
                public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WebhookInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WebhookInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WebhookInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WebhookInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebhookInner object if successful.
     */
    public WebhookInner create(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).toBlocking().last().body();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters, final ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters), serviceCallback);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).map(new Func1<ServiceResponse<WebhookInner>, WebhookInner>() {
            @Override
            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<WebhookInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (webhookCreateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null.");
        }
        Validator.validate(webhookCreateParameters);
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), webhookCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WebhookInner>() { }.getType());
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebhookInner object if successful.
     */
    public WebhookInner beginCreate(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).toBlocking().single().body();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters, final ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters), serviceCallback);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).map(new Func1<ServiceResponse<WebhookInner>, WebhookInner>() {
            @Override
            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<ServiceResponse<WebhookInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParametersInner webhookCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (webhookCreateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null.");
        }
        Validator.validate(webhookCreateParameters);
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), webhookCreateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>() {
                @Override
                public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WebhookInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WebhookInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WebhookInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WebhookInner>() { }.getType())
                .register(201, new TypeToken<WebhookInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName, String webhookName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().last().body();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName, String webhookName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single().body();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebhookInner object if successful.
     */
    public WebhookInner update(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters, final ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters), serviceCallback);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).map(new Func1<ServiceResponse<WebhookInner>, WebhookInner>() {
            @Override
            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<WebhookInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (webhookUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null.");
        }
        Validator.validate(webhookUpdateParameters);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), webhookUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WebhookInner>() { }.getType());
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WebhookInner object if successful.
     */
    public WebhookInner beginUpdate(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters, final ServiceCallback<WebhookInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters), serviceCallback);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).map(new Func1<ServiceResponse<WebhookInner>, WebhookInner>() {
            @Override
            public WebhookInner call(ServiceResponse<WebhookInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WebhookInner object
     */
    public Observable<ServiceResponse<WebhookInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParametersInner webhookUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (webhookUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null.");
        }
        Validator.validate(webhookUpdateParameters);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), webhookUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WebhookInner>>>() {
                @Override
                public Observable<ServiceResponse<WebhookInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WebhookInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WebhookInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WebhookInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WebhookInner>() { }.getType())
                .register(201, new TypeToken<WebhookInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebhookInner&gt; object if successful.
     */
    public PagedList<WebhookInner> list(final String resourceGroupName, final String registryName) {
        ServiceResponse<Page<WebhookInner>> response = listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<WebhookInner>(response.body()) {
            @Override
            public Page<WebhookInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebhookInner>> listAsync(final String resourceGroupName, final String registryName, final ListOperationCallback<WebhookInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName),
            new Func1<String, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebhookInner&gt; object
     */
    public Observable<Page<WebhookInner>> listAsync(final String resourceGroupName, final String registryName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName)
            .map(new Func1<ServiceResponse<Page<WebhookInner>>, Page<WebhookInner>>() {
                @Override
                public Page<WebhookInner> call(ServiceResponse<Page<WebhookInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebhookInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebhookInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName) {
        return listSinglePageAsync(resourceGroupName, registryName)
            .concatMap(new Func1<ServiceResponse<Page<WebhookInner>>, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(ServiceResponse<Page<WebhookInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
    ServiceResponse<PageImpl<WebhookInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<WebhookInner>> * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebhookInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebhookInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebhookInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebhookInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebhookInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebhookInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebhookInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EventInfoInner object if successful.
     */
    public EventInfoInner ping(String resourceGroupName, String registryName, String webhookName) {
        return pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single().body();
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName, final ServiceCallback<EventInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EventInfoInner object
     */
    public Observable<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName) {
        return pingWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map(new Func1<ServiceResponse<EventInfoInner>, EventInfoInner>() {
            @Override
            public EventInfoInner call(ServiceResponse<EventInfoInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EventInfoInner object
     */
    public Observable<ServiceResponse<EventInfoInner>> pingWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.ping(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EventInfoInner>>>() {
                @Override
                public Observable<ServiceResponse<EventInfoInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EventInfoInner> clientResponse = pingDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EventInfoInner> pingDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EventInfoInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EventInfoInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CallbackConfigInner object if successful.
     */
    public CallbackConfigInner getCallbackConfig(String resourceGroupName, String registryName, String webhookName) {
        return getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName).toBlocking().single().body();
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CallbackConfigInner> getCallbackConfigAsync(String resourceGroupName, String registryName, String webhookName, final ServiceCallback<CallbackConfigInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName), serviceCallback);
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CallbackConfigInner object
     */
    public Observable<CallbackConfigInner> getCallbackConfigAsync(String resourceGroupName, String registryName, String webhookName) {
        return getCallbackConfigWithServiceResponseAsync(resourceGroupName, registryName, webhookName).map(new Func1<ServiceResponse<CallbackConfigInner>, CallbackConfigInner>() {
            @Override
            public CallbackConfigInner call(ServiceResponse<CallbackConfigInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CallbackConfigInner object
     */
    public Observable<ServiceResponse<CallbackConfigInner>> getCallbackConfigWithServiceResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCallbackConfig(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CallbackConfigInner>>>() {
                @Override
                public Observable<ServiceResponse<CallbackConfigInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CallbackConfigInner> clientResponse = getCallbackConfigDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CallbackConfigInner> getCallbackConfigDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CallbackConfigInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CallbackConfigInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EventInner&gt; object if successful.
     */
    public PagedList<EventInner> listEvents(final String resourceGroupName, final String registryName, final String webhookName) {
        ServiceResponse<Page<EventInner>> response = listEventsSinglePageAsync(resourceGroupName, registryName, webhookName).toBlocking().single();
        return new PagedList<EventInner>(response.body()) {
            @Override
            public Page<EventInner> nextPage(String nextPageLink) {
                return listEventsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EventInner>> listEventsAsync(final String resourceGroupName, final String registryName, final String webhookName, final ListOperationCallback<EventInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listEventsSinglePageAsync(resourceGroupName, registryName, webhookName),
            new Func1<String, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(String nextPageLink) {
                    return listEventsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EventInner&gt; object
     */
    public Observable<Page<EventInner>> listEventsAsync(final String resourceGroupName, final String registryName, final String webhookName) {
        return listEventsWithServiceResponseAsync(resourceGroupName, registryName, webhookName)
            .map(new Func1<ServiceResponse<Page<EventInner>>, Page<EventInner>>() {
                @Override
                public Page<EventInner> call(ServiceResponse<Page<EventInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EventInner&gt; object
     */
    public Observable<ServiceResponse<Page<EventInner>>> listEventsWithServiceResponseAsync(final String resourceGroupName, final String registryName, final String webhookName) {
        return listEventsSinglePageAsync(resourceGroupName, registryName, webhookName)
            .concatMap(new Func1<ServiceResponse<Page<EventInner>>, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(ServiceResponse<Page<EventInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listEventsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists recent events for the specified webhook.
     *
    ServiceResponse<PageImpl<EventInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<EventInner>> * @param registryName The name of the container registry.
    ServiceResponse<PageImpl<EventInner>> * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EventInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EventInner>>> listEventsSinglePageAsync(final String resourceGroupName, final String registryName, final String webhookName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (webhookName == null) {
            throw new IllegalArgumentException("Parameter webhookName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listEvents(this.client.subscriptionId(), resourceGroupName, registryName, webhookName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<EventInner>> result = listEventsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EventInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<EventInner>> listEventsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<EventInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<EventInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WebhookInner&gt; object if successful.
     */
    public PagedList<WebhookInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<WebhookInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WebhookInner>(response.body()) {
            @Override
            public Page<WebhookInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WebhookInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<WebhookInner>> serviceFuture, final ListOperationCallback<WebhookInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebhookInner&gt; object
     */
    public Observable<Page<WebhookInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<WebhookInner>>, Page<WebhookInner>>() {
                @Override
                public Page<WebhookInner> call(ServiceResponse<Page<WebhookInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WebhookInner&gt; object
     */
    public Observable<ServiceResponse<Page<WebhookInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<WebhookInner>>, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(ServiceResponse<Page<WebhookInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
    ServiceResponse<PageImpl<WebhookInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WebhookInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WebhookInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WebhookInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WebhookInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WebhookInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WebhookInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WebhookInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WebhookInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WebhookInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EventInner&gt; object if successful.
     */
    public PagedList<EventInner> listEventsNext(final String nextPageLink) {
        ServiceResponse<Page<EventInner>> response = listEventsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EventInner>(response.body()) {
            @Override
            public Page<EventInner> nextPage(String nextPageLink) {
                return listEventsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EventInner>> listEventsNextAsync(final String nextPageLink, final ServiceFuture<List<EventInner>> serviceFuture, final ListOperationCallback<EventInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listEventsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(String nextPageLink) {
                    return listEventsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EventInner&gt; object
     */
    public Observable<Page<EventInner>> listEventsNextAsync(final String nextPageLink) {
        return listEventsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<EventInner>>, Page<EventInner>>() {
                @Override
                public Page<EventInner> call(ServiceResponse<Page<EventInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EventInner&gt; object
     */
    public Observable<ServiceResponse<Page<EventInner>>> listEventsNextWithServiceResponseAsync(final String nextPageLink) {
        return listEventsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<EventInner>>, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(ServiceResponse<Page<EventInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listEventsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists recent events for the specified webhook.
     *
    ServiceResponse<PageImpl<EventInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EventInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EventInner>>> listEventsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listEventsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EventInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<EventInner>> result = listEventsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EventInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<EventInner>> listEventsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<EventInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<EventInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
