/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties that are enabled for Odata querying.
 */
public class BuildFilter {
    /**
     * The unique identifier for the build.
     */
    @JsonProperty(value = "buildId")
    private String buildId;

    /**
     * The type of build. Possible values include: 'AutoBuild', 'QuickBuild'.
     */
    @JsonProperty(value = "buildType")
    private BuildType buildType;

    /**
     * The current status of the build. Possible values include: 'Queued',
     * 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled', 'Error',
     * 'Timeout'.
     */
    @JsonProperty(value = "status")
    private BuildStatus status;

    /**
     * The create time for a build.
     */
    @JsonProperty(value = "createTime")
    private DateTime createTime;

    /**
     * The time the build finished.
     */
    @JsonProperty(value = "finishTime")
    private DateTime finishTime;

    /**
     * The list of comma-separated image manifests that were generated from the
     * build.
     */
    @JsonProperty(value = "outputImageManifests")
    private String outputImageManifests;

    /**
     * The value that indicates whether archiving is enabled or not.
     */
    @JsonProperty(value = "isArchiveEnabled")
    private Boolean isArchiveEnabled;

    /**
     * The name of the build task that the build corresponds to.
     */
    @JsonProperty(value = "buildTaskName")
    private String buildTaskName;

    /**
     * Get the buildId value.
     *
     * @return the buildId value
     */
    public String buildId() {
        return this.buildId;
    }

    /**
     * Set the buildId value.
     *
     * @param buildId the buildId value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withBuildId(String buildId) {
        this.buildId = buildId;
        return this;
    }

    /**
     * Get the buildType value.
     *
     * @return the buildType value
     */
    public BuildType buildType() {
        return this.buildType;
    }

    /**
     * Set the buildType value.
     *
     * @param buildType the buildType value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withBuildType(BuildType buildType) {
        this.buildType = buildType;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public BuildStatus status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withStatus(BuildStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the createTime value.
     *
     * @return the createTime value
     */
    public DateTime createTime() {
        return this.createTime;
    }

    /**
     * Set the createTime value.
     *
     * @param createTime the createTime value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withCreateTime(DateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * Get the finishTime value.
     *
     * @return the finishTime value
     */
    public DateTime finishTime() {
        return this.finishTime;
    }

    /**
     * Set the finishTime value.
     *
     * @param finishTime the finishTime value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withFinishTime(DateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    /**
     * Get the outputImageManifests value.
     *
     * @return the outputImageManifests value
     */
    public String outputImageManifests() {
        return this.outputImageManifests;
    }

    /**
     * Set the outputImageManifests value.
     *
     * @param outputImageManifests the outputImageManifests value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withOutputImageManifests(String outputImageManifests) {
        this.outputImageManifests = outputImageManifests;
        return this;
    }

    /**
     * Get the isArchiveEnabled value.
     *
     * @return the isArchiveEnabled value
     */
    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    /**
     * Set the isArchiveEnabled value.
     *
     * @param isArchiveEnabled the isArchiveEnabled value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    /**
     * Get the buildTaskName value.
     *
     * @return the buildTaskName value
     */
    public String buildTaskName() {
        return this.buildTaskName;
    }

    /**
     * Set the buildTaskName value.
     *
     * @param buildTaskName the buildTaskName value to set
     * @return the BuildFilter object itself.
     */
    public BuildFilter withBuildTaskName(String buildTaskName) {
        this.buildTaskName = buildTaskName;
        return this;
    }

}
