/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import java.util.List;
import com.microsoft.azure.management.containerregistry.implementation.BuildArgumentInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The properties for updating a docker build step.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("Docker")
public class DockerBuildStepUpdateParameters extends BuildStepPropertiesUpdateParameters {
    /**
     * The repository branch name.
     */
    @JsonProperty(value = "branch")
    private String branch;

    /**
     * The fully qualified image names including the repository and tag.
     */
    @JsonProperty(value = "imageNames")
    private List<String> imageNames;

    /**
     * The value of this property indicates whether the image built should be
     * pushed to the registry or not.
     */
    @JsonProperty(value = "isPushEnabled")
    private Boolean isPushEnabled;

    /**
     * The value of this property indicates whether the image cache is enabled
     * or not.
     */
    @JsonProperty(value = "noCache")
    private Boolean noCache;

    /**
     * The Docker file path relative to the source control root.
     */
    @JsonProperty(value = "dockerFilePath")
    private String dockerFilePath;

    /**
     * The relative context path for a docker build in the source.
     */
    @JsonProperty(value = "contextPath")
    private String contextPath;

    /**
     * The custom arguments for building this build step.
     */
    @JsonProperty(value = "buildArguments")
    private List<BuildArgumentInner> buildArguments;

    /**
     * The type of the auto trigger for base image dependency updates. Possible
     * values include: 'All', 'Runtime', 'None'.
     */
    @JsonProperty(value = "baseImageTrigger")
    private BaseImageTriggerType baseImageTrigger;

    /**
     * Get the branch value.
     *
     * @return the branch value
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch value.
     *
     * @param branch the branch value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the imageNames value.
     *
     * @return the imageNames value
     */
    public List<String> imageNames() {
        return this.imageNames;
    }

    /**
     * Set the imageNames value.
     *
     * @param imageNames the imageNames value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    /**
     * Get the isPushEnabled value.
     *
     * @return the isPushEnabled value
     */
    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    /**
     * Set the isPushEnabled value.
     *
     * @param isPushEnabled the isPushEnabled value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    /**
     * Get the noCache value.
     *
     * @return the noCache value
     */
    public Boolean noCache() {
        return this.noCache;
    }

    /**
     * Set the noCache value.
     *
     * @param noCache the noCache value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    /**
     * Get the dockerFilePath value.
     *
     * @return the dockerFilePath value
     */
    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    /**
     * Set the dockerFilePath value.
     *
     * @param dockerFilePath the dockerFilePath value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    /**
     * Get the contextPath value.
     *
     * @return the contextPath value
     */
    public String contextPath() {
        return this.contextPath;
    }

    /**
     * Set the contextPath value.
     *
     * @param contextPath the contextPath value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    /**
     * Get the buildArguments value.
     *
     * @return the buildArguments value
     */
    public List<BuildArgumentInner> buildArguments() {
        return this.buildArguments;
    }

    /**
     * Set the buildArguments value.
     *
     * @param buildArguments the buildArguments value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withBuildArguments(List<BuildArgumentInner> buildArguments) {
        this.buildArguments = buildArguments;
        return this;
    }

    /**
     * Get the baseImageTrigger value.
     *
     * @return the baseImageTrigger value
     */
    public BaseImageTriggerType baseImageTrigger() {
        return this.baseImageTrigger;
    }

    /**
     * Set the baseImageTrigger value.
     *
     * @param baseImageTrigger the baseImageTrigger value to set
     * @return the DockerBuildStepUpdateParameters object itself.
     */
    public DockerBuildStepUpdateParameters withBaseImageTrigger(BaseImageTriggerType baseImageTrigger) {
        this.baseImageTrigger = baseImageTrigger;
        return this;
    }

}
