/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for OsType.
 */
public final class OsType extends ExpandableStringEnum<OsType> {
    /** Static value Windows for OsType. */
    public static final OsType WINDOWS = fromString("Windows");

    /** Static value Linux for OsType. */
    public static final OsType LINUX = fromString("Linux");

    /**
     * Creates or finds a OsType from its string representation.
     * @param name a name to look for
     * @return the corresponding OsType
     */
    @JsonCreator
    public static OsType fromString(String name) {
        return fromString(name, OsType.class);
    }

    /**
     * @return known OsType values
     */
    public static Collection<OsType> values() {
        return values(OsType.class);
    }
}
