/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The platform properties against which the build has to happen.
 */
public class PlatformProperties {
    /**
     * The operating system type required for the build. Possible values
     * include: 'Windows', 'Linux'.
     */
    @JsonProperty(value = "osType", required = true)
    private OsType osType;

    /**
     * The CPU configuration in terms of number of cores required for the
     * build.
     */
    @JsonProperty(value = "cpu")
    private Integer cpu;

    /**
     * Get the osType value.
     *
     * @return the osType value
     */
    public OsType osType() {
        return this.osType;
    }

    /**
     * Set the osType value.
     *
     * @param osType the osType value to set
     * @return the PlatformProperties object itself.
     */
    public PlatformProperties withOsType(OsType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the cpu value.
     *
     * @return the cpu value
     */
    public Integer cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu value.
     *
     * @param cpu the cpu value to set
     * @return the PlatformProperties object itself.
     */
    public PlatformProperties withCpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

}
