/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.containerregistry.BuildStepPropertiesUpdateParameters;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The parameters for updating a build step.
 */
public class BuildStepUpdateParametersInner {
    /**
     * The properties for updating a build step.
     */
    @JsonProperty(value = "properties")
    private BuildStepPropertiesUpdateParameters properties;

    /**
     * The ARM resource tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Get the properties value.
     *
     * @return the properties value
     */
    public BuildStepPropertiesUpdateParameters properties() {
        return this.properties;
    }

    /**
     * Set the properties value.
     *
     * @param properties the properties value to set
     * @return the BuildStepUpdateParametersInner object itself.
     */
    public BuildStepUpdateParametersInner withProperties(BuildStepPropertiesUpdateParameters properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the BuildStepUpdateParametersInner object itself.
     */
    public BuildStepUpdateParametersInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

}
