/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in BuildSteps.
 */
public class BuildStepsInner {
    /** The Retrofit service to perform REST calls. */
    private BuildStepsService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of BuildStepsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public BuildStepsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(BuildStepsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for BuildSteps to be
     * used by Retrofit to perform actually REST calls.
     */
    interface BuildStepsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BuildStepInner buildStepCreateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BuildStepInner buildStepCreateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Body BuildStepUpdateParametersInner buildStepUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Body BuildStepUpdateParametersInner buildStepUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listBuildArguments" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}/listBuildArguments")
        Observable<Response<ResponseBody>> listBuildArguments(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Path("stepName") String stepName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listBuildArgumentsNext" })
        @GET
        Observable<Response<ResponseBody>> listBuildArgumentsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List all the build steps for a given build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildStepInner&gt; object if successful.
     */
    public PagedList<BuildStepInner> list(final String resourceGroupName, final String registryName, final String buildTaskName) {
        ServiceResponse<Page<BuildStepInner>> response = listSinglePageAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single();
        return new PagedList<BuildStepInner>(response.body()) {
            @Override
            public Page<BuildStepInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildStepInner>> listAsync(final String resourceGroupName, final String registryName, final String buildTaskName, final ListOperationCallback<BuildStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName, buildTaskName),
            new Func1<String, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildStepInner&gt; object
     */
    public Observable<Page<BuildStepInner>> listAsync(final String resourceGroupName, final String registryName, final String buildTaskName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName)
            .map(new Func1<ServiceResponse<Page<BuildStepInner>>, Page<BuildStepInner>>() {
                @Override
                public Page<BuildStepInner> call(ServiceResponse<Page<BuildStepInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildStepInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildStepInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName, final String buildTaskName) {
        return listSinglePageAsync(resourceGroupName, registryName, buildTaskName)
            .concatMap(new Func1<ServiceResponse<Page<BuildStepInner>>, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(ServiceResponse<Page<BuildStepInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all the build steps for a given build task.
     *
    ServiceResponse<PageImpl<BuildStepInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<BuildStepInner>> * @param registryName The name of the container registry.
    ServiceResponse<PageImpl<BuildStepInner>> * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildStepInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildStepInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName, final String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildStepInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildStepInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildStepInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildStepInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildStepInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner get(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single().body();
    }

    /**
     * Gets the build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    /**
     * Gets the build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<BuildStepInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<ServiceResponse<BuildStepInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildStepInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildStepInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildStepInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildStepInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner create(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().last().body();
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildStepInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final BuildStepPropertiesInner properties = null;
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(null);
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>() { }.getType());
    }
    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner create(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).toBlocking().last().body();
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties), serviceCallback);
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildStepInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        Validator.validate(properties);
        final String apiVersion = "2018-02-01-preview";
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(properties);
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>() { }.getType());
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single().body();
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<ServiceResponse<BuildStepInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final BuildStepPropertiesInner properties = null;
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(null);
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildStepInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).toBlocking().single().body();
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties), serviceCallback);
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build step for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param properties The properties of a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<ServiceResponse<BuildStepInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        Validator.validate(properties);
        final String apiVersion = "2018-02-01-preview";
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(properties);
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildStepInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildStepInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildStepInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildStepInner>() { }.getType())
                .register(201, new TypeToken<BuildStepInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().last().body();
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single().body();
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a build step from the build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner update(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters), serviceCallback);
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildStepInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildStepInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (buildStepUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildStepUpdateParameters is required and cannot be null.");
        }
        Validator.validate(buildStepUpdateParameters);
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, buildStepUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>() { }.getType());
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildStepInner object if successful.
     */
    public BuildStepInner beginUpdate(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildStepInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters, final ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters), serviceCallback);
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<BuildStepInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).map(new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>() {
            @Override
            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a build step in a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param buildStepUpdateParameters The parameters for updating a build step.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildStepInner object
     */
    public Observable<ServiceResponse<BuildStepInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (buildStepUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildStepUpdateParameters is required and cannot be null.");
        }
        Validator.validate(buildStepUpdateParameters);
        final String apiVersion = "2018-02-01-preview";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, buildStepUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildStepInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildStepInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildStepInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildStepInner>() { }.getType())
                .register(201, new TypeToken<BuildStepInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildArgumentInner&gt; object if successful.
     */
    public PagedList<BuildArgumentInner> listBuildArguments(final String resourceGroupName, final String registryName, final String buildTaskName, final String stepName) {
        ServiceResponse<Page<BuildArgumentInner>> response = listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single();
        return new PagedList<BuildArgumentInner>(response.body()) {
            @Override
            public Page<BuildArgumentInner> nextPage(String nextPageLink) {
                return listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildArgumentInner>> listBuildArgumentsAsync(final String resourceGroupName, final String registryName, final String buildTaskName, final String stepName, final ListOperationCallback<BuildArgumentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName),
            new Func1<String, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(String nextPageLink) {
                    return listBuildArgumentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildArgumentInner&gt; object
     */
    public Observable<Page<BuildArgumentInner>> listBuildArgumentsAsync(final String resourceGroupName, final String registryName, final String buildTaskName, final String stepName) {
        return listBuildArgumentsWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName)
            .map(new Func1<ServiceResponse<Page<BuildArgumentInner>>, Page<BuildArgumentInner>>() {
                @Override
                public Page<BuildArgumentInner> call(ServiceResponse<Page<BuildArgumentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildArgumentInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsWithServiceResponseAsync(final String resourceGroupName, final String registryName, final String buildTaskName, final String stepName) {
        return listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName)
            .concatMap(new Func1<ServiceResponse<Page<BuildArgumentInner>>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(ServiceResponse<Page<BuildArgumentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBuildArgumentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
    ServiceResponse<PageImpl<BuildArgumentInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<BuildArgumentInner>> * @param registryName The name of the container registry.
    ServiceResponse<PageImpl<BuildArgumentInner>> * @param buildTaskName The name of the container registry build task.
    ServiceResponse<PageImpl<BuildArgumentInner>> * @param stepName The name of a build step for a container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildArgumentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsSinglePageAsync(final String resourceGroupName, final String registryName, final String buildTaskName, final String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.listBuildArguments(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildArgumentInner>> result = listBuildArgumentsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildArgumentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildArgumentInner>> listBuildArgumentsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildArgumentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildArgumentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildStepInner&gt; object if successful.
     */
    public PagedList<BuildStepInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<BuildStepInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildStepInner>(response.body()) {
            @Override
            public Page<BuildStepInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildStepInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<BuildStepInner>> serviceFuture, final ListOperationCallback<BuildStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildStepInner&gt; object
     */
    public Observable<Page<BuildStepInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BuildStepInner>>, Page<BuildStepInner>>() {
                @Override
                public Page<BuildStepInner> call(ServiceResponse<Page<BuildStepInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all the build steps for a given build task.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildStepInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildStepInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BuildStepInner>>, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(ServiceResponse<Page<BuildStepInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all the build steps for a given build task.
     *
    ServiceResponse<PageImpl<BuildStepInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildStepInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildStepInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildStepInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildStepInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildStepInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildStepInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildStepInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildStepInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildStepInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildArgumentInner&gt; object if successful.
     */
    public PagedList<BuildArgumentInner> listBuildArgumentsNext(final String nextPageLink) {
        ServiceResponse<Page<BuildArgumentInner>> response = listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildArgumentInner>(response.body()) {
            @Override
            public Page<BuildArgumentInner> nextPage(String nextPageLink) {
                return listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildArgumentInner>> listBuildArgumentsNextAsync(final String nextPageLink, final ServiceFuture<List<BuildArgumentInner>> serviceFuture, final ListOperationCallback<BuildArgumentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBuildArgumentsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(String nextPageLink) {
                    return listBuildArgumentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildArgumentInner&gt; object
     */
    public Observable<Page<BuildArgumentInner>> listBuildArgumentsNextAsync(final String nextPageLink) {
        return listBuildArgumentsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BuildArgumentInner>>, Page<BuildArgumentInner>>() {
                @Override
                public Page<BuildArgumentInner> call(ServiceResponse<Page<BuildArgumentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildArgumentInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsNextWithServiceResponseAsync(final String nextPageLink) {
        return listBuildArgumentsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BuildArgumentInner>>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(ServiceResponse<Page<BuildArgumentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBuildArgumentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List the build arguments for a step including the secret arguments.
     *
    ServiceResponse<PageImpl<BuildArgumentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildArgumentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBuildArgumentsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildArgumentInner>> result = listBuildArgumentsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildArgumentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildArgumentInner>> listBuildArgumentsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildArgumentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildArgumentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
