/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.containerregistry.ProvisioningState;
import org.joda.time.DateTime;
import com.microsoft.azure.management.containerregistry.BuildTaskStatus;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * The build task that has the resource properties and all build items. The
 * build task will have all information to schedule a build against it.
 */
@JsonFlatten
public class BuildTaskInner extends Resource {
    /**
     * The provisioning state of the build task. Possible values include:
     * 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * The creation date of build task.
     */
    @JsonProperty(value = "properties.creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationDate;

    /**
     * The alternative updatable name for a build task.
     */
    @JsonProperty(value = "properties.alias", required = true)
    private String alias;

    /**
     * The current status of build task. Possible values include: 'Disabled',
     * 'Enabled'.
     */
    @JsonProperty(value = "properties.status")
    private BuildTaskStatus status;

    /**
     * The properties that describes the source(code) for the build task.
     */
    @JsonProperty(value = "properties.sourceRepository", required = true)
    private SourceRepositoryPropertiesInner sourceRepository;

    /**
     * The platform properties against which the build has to happen.
     */
    @JsonProperty(value = "properties.platform", required = true)
    private PlatformProperties platform;

    /**
     * Build timeout in seconds.
     */
    @JsonProperty(value = "properties.timeout")
    private Integer timeout;

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the creationDate value.
     *
     * @return the creationDate value
     */
    public DateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the alias value.
     *
     * @return the alias value
     */
    public String alias() {
        return this.alias;
    }

    /**
     * Set the alias value.
     *
     * @param alias the alias value to set
     * @return the BuildTaskInner object itself.
     */
    public BuildTaskInner withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public BuildTaskStatus status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the BuildTaskInner object itself.
     */
    public BuildTaskInner withStatus(BuildTaskStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the sourceRepository value.
     *
     * @return the sourceRepository value
     */
    public SourceRepositoryPropertiesInner sourceRepository() {
        return this.sourceRepository;
    }

    /**
     * Set the sourceRepository value.
     *
     * @param sourceRepository the sourceRepository value to set
     * @return the BuildTaskInner object itself.
     */
    public BuildTaskInner withSourceRepository(SourceRepositoryPropertiesInner sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    /**
     * Get the platform value.
     *
     * @return the platform value
     */
    public PlatformProperties platform() {
        return this.platform;
    }

    /**
     * Set the platform value.
     *
     * @param platform the platform value to set
     * @return the BuildTaskInner object itself.
     */
    public BuildTaskInner withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    /**
     * Get the timeout value.
     *
     * @return the timeout value
     */
    public Integer timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout value.
     *
     * @param timeout the timeout value to set
     * @return the BuildTaskInner object itself.
     */
    public BuildTaskInner withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

}
