/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in BuildTasks.
 */
public class BuildTasksInner {
    /** The Retrofit service to perform REST calls. */
    private BuildTasksService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of BuildTasksInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public BuildTasksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(BuildTasksService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for BuildTasks to be
     * used by Retrofit to perform actually REST calls.
     */
    interface BuildTasksService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Query("$skipToken") String skipToken, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Body BuildTaskInner buildTaskCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Body BuildTaskInner buildTaskCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Body BuildTaskUpdateParametersInner buildTaskUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Body BuildTaskUpdateParametersInner buildTaskUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks listSourceRepositoryProperties" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/listSourceRepositoryProperties")
        Observable<Response<ResponseBody>> listSourceRepositoryProperties(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildTaskName") String buildTaskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildTaskInner&gt; object if successful.
     */
    public PagedList<BuildTaskInner> list(final String resourceGroupName, final String registryName) {
        ServiceResponse<Page<BuildTaskInner>> response = listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<BuildTaskInner>(response.body()) {
            @Override
            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildTaskInner>> listAsync(final String resourceGroupName, final String registryName, final ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName),
            new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<Page<BuildTaskInner>> listAsync(final String resourceGroupName, final String registryName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName)
            .map(new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>() {
                @Override
                public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName) {
        return listSinglePageAsync(resourceGroupName, registryName)
            .concatMap(new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildTaskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final String filter = null;
        final String skipToken = null;
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, filter, skipToken, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildTaskInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildTaskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The build task filter to apply on the operation.
     * @param skipToken $skipToken is supported on get list of build tasks, which provides the next page in the list of tasks.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildTaskInner&gt; object if successful.
     */
    public PagedList<BuildTaskInner> list(final String resourceGroupName, final String registryName, final String filter, final String skipToken) {
        ServiceResponse<Page<BuildTaskInner>> response = listSinglePageAsync(resourceGroupName, registryName, filter, skipToken).toBlocking().single();
        return new PagedList<BuildTaskInner>(response.body()) {
            @Override
            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The build task filter to apply on the operation.
     * @param skipToken $skipToken is supported on get list of build tasks, which provides the next page in the list of tasks.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildTaskInner>> listAsync(final String resourceGroupName, final String registryName, final String filter, final String skipToken, final ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName, filter, skipToken),
            new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The build task filter to apply on the operation.
     * @param skipToken $skipToken is supported on get list of build tasks, which provides the next page in the list of tasks.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<Page<BuildTaskInner>> listAsync(final String resourceGroupName, final String registryName, final String filter, final String skipToken) {
        return listWithServiceResponseAsync(resourceGroupName, registryName, filter, skipToken)
            .map(new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>() {
                @Override
                public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The build task filter to apply on the operation.
     * @param skipToken $skipToken is supported on get list of build tasks, which provides the next page in the list of tasks.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName, final String filter, final String skipToken) {
        return listSinglePageAsync(resourceGroupName, registryName, filter, skipToken)
            .concatMap(new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
    ServiceResponse<PageImpl<BuildTaskInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<BuildTaskInner>> * @param registryName The name of the container registry.
    ServiceResponse<PageImpl<BuildTaskInner>> * @param filter The build task filter to apply on the operation.
    ServiceResponse<PageImpl<BuildTaskInner>> * @param skipToken $skipToken is supported on get list of build tasks, which provides the next page in the list of tasks.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildTaskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName, final String filter, final String skipToken) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, filter, skipToken, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildTaskInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildTaskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildTaskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildTaskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildTaskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the properties of a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildTaskInner object if successful.
     */
    public BuildTaskInner get(String resourceGroupName, String registryName, String buildTaskName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single().body();
    }

    /**
     * Get the properties of a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildTaskInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, final ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    /**
     * Get the properties of a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<BuildTaskInner> getAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map(new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>() {
            @Override
            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the properties of a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<ServiceResponse<BuildTaskInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildTaskInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildTaskInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildTaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildTaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildTaskInner object if successful.
     */
    public BuildTaskInner create(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).toBlocking().last().body();
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildTaskInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters, final ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters), serviceCallback);
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildTaskInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).map(new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>() {
            @Override
            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildTaskInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskCreateParameters is required and cannot be null.");
        }
        Validator.validate(buildTaskCreateParameters);
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, buildTaskCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildTaskInner>() { }.getType());
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildTaskInner object if successful.
     */
    public BuildTaskInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).toBlocking().single().body();
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildTaskInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters, final ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters), serviceCallback);
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<BuildTaskInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).map(new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>() {
            @Override
            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a build task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskCreateParameters The parameters for creating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<ServiceResponse<BuildTaskInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskCreateParameters is required and cannot be null.");
        }
        Validator.validate(buildTaskCreateParameters);
        final String apiVersion = "2018-02-01-preview";
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, buildTaskCreateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildTaskInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildTaskInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildTaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildTaskInner>() { }.getType())
                .register(201, new TypeToken<BuildTaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName, String buildTaskName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().last().body();
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName, String buildTaskName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single().body();
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a specified build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildTaskInner object if successful.
     */
    public BuildTaskInner update(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildTaskInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters, final ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters), serviceCallback);
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildTaskInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).map(new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>() {
            @Override
            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildTaskInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskUpdateParameters is required and cannot be null.");
        }
        Validator.validate(buildTaskUpdateParameters);
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, buildTaskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildTaskInner>() { }.getType());
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildTaskInner object if successful.
     */
    public BuildTaskInner beginUpdate(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildTaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters, final ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters), serviceCallback);
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<BuildTaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).map(new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>() {
            @Override
            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a build task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param buildTaskUpdateParameters The parameters for updating a build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildTaskInner object
     */
    public Observable<ServiceResponse<BuildTaskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskUpdateParameters is required and cannot be null.");
        }
        Validator.validate(buildTaskUpdateParameters);
        final String apiVersion = "2018-02-01-preview";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, buildTaskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildTaskInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildTaskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildTaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildTaskInner>() { }.getType())
                .register(201, new TypeToken<BuildTaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the source control properties for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SourceRepositoryPropertiesInner object if successful.
     */
    public SourceRepositoryPropertiesInner listSourceRepositoryProperties(String resourceGroupName, String registryName, String buildTaskName) {
        return listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single().body();
    }

    /**
     * Get the source control properties for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesAsync(String resourceGroupName, String registryName, String buildTaskName, final ServiceCallback<SourceRepositoryPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    /**
     * Get the source control properties for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceRepositoryPropertiesInner object
     */
    public Observable<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map(new Func1<ServiceResponse<SourceRepositoryPropertiesInner>, SourceRepositoryPropertiesInner>() {
            @Override
            public SourceRepositoryPropertiesInner call(ServiceResponse<SourceRepositoryPropertiesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the source control properties for a build task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildTaskName The name of the container registry build task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceRepositoryPropertiesInner object
     */
    public Observable<ServiceResponse<SourceRepositoryPropertiesInner>> listSourceRepositoryPropertiesWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.listSourceRepositoryProperties(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceRepositoryPropertiesInner>>>() {
                @Override
                public Observable<ServiceResponse<SourceRepositoryPropertiesInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SourceRepositoryPropertiesInner> clientResponse = listSourceRepositoryPropertiesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SourceRepositoryPropertiesInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SourceRepositoryPropertiesInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildTaskInner&gt; object if successful.
     */
    public PagedList<BuildTaskInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<BuildTaskInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildTaskInner>(response.body()) {
            @Override
            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildTaskInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<BuildTaskInner>> serviceFuture, final ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<Page<BuildTaskInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>() {
                @Override
                public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildTaskInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the build tasks for a specified container registry.
     *
    ServiceResponse<PageImpl<BuildTaskInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildTaskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildTaskInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildTaskInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildTaskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildTaskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildTaskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildTaskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
