/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.containerregistry.BuildUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Builds.
 */
public class BuildsInner {
    /** The Retrofit service to perform REST calls. */
    private BuildsService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of BuildsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public BuildsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(BuildsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Builds to be
     * used by Retrofit to perform actually REST calls.
     */
    interface BuildsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Query("$filter") String filter, @Query("$top") Integer top, @Query("$skipToken") String skipToken, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BuildUpdateParameters buildUpdateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body BuildUpdateParameters buildUpdateParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds getLogLink" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/getLogLink")
        Observable<Response<ResponseBody>> getLogLink(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds cancel" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/cancel")
        Observable<Response<ResponseBody>> cancel(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds beginCancel" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/cancel")
        Observable<Response<ResponseBody>> beginCancel(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("buildId") String buildId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildInner&gt; object if successful.
     */
    public PagedList<BuildInner> list(final String resourceGroupName, final String registryName) {
        ServiceResponse<Page<BuildInner>> response = listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<BuildInner>(response.body()) {
            @Override
            public Page<BuildInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildInner>> listAsync(final String resourceGroupName, final String registryName, final ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName),
            new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<Page<BuildInner>> listAsync(final String resourceGroupName, final String registryName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName)
            .map(new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>() {
                @Override
                public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName) {
        return listSinglePageAsync(resourceGroupName, registryName)
            .concatMap(new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final String filter = null;
        final Integer top = null;
        final String skipToken = null;
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, filter, top, skipToken, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The builds filter to apply on the operation.
     * @param top $top is supported for get list of builds, which limits the maximum number of builds to return.
     * @param skipToken $skipToken is supported on get list of builds, which provides the next page in the list of builds.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildInner&gt; object if successful.
     */
    public PagedList<BuildInner> list(final String resourceGroupName, final String registryName, final String filter, final Integer top, final String skipToken) {
        ServiceResponse<Page<BuildInner>> response = listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken).toBlocking().single();
        return new PagedList<BuildInner>(response.body()) {
            @Override
            public Page<BuildInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The builds filter to apply on the operation.
     * @param top $top is supported for get list of builds, which limits the maximum number of builds to return.
     * @param skipToken $skipToken is supported on get list of builds, which provides the next page in the list of builds.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildInner>> listAsync(final String resourceGroupName, final String registryName, final String filter, final Integer top, final String skipToken, final ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken),
            new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The builds filter to apply on the operation.
     * @param top $top is supported for get list of builds, which limits the maximum number of builds to return.
     * @param skipToken $skipToken is supported on get list of builds, which provides the next page in the list of builds.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<Page<BuildInner>> listAsync(final String resourceGroupName, final String registryName, final String filter, final Integer top, final String skipToken) {
        return listWithServiceResponseAsync(resourceGroupName, registryName, filter, top, skipToken)
            .map(new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>() {
                @Override
                public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The builds filter to apply on the operation.
     * @param top $top is supported for get list of builds, which limits the maximum number of builds to return.
     * @param skipToken $skipToken is supported on get list of builds, which provides the next page in the list of builds.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName, final String filter, final Integer top, final String skipToken) {
        return listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken)
            .concatMap(new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
    ServiceResponse<PageImpl<BuildInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<BuildInner>> * @param registryName The name of the container registry.
    ServiceResponse<PageImpl<BuildInner>> * @param filter The builds filter to apply on the operation.
    ServiceResponse<PageImpl<BuildInner>> * @param top $top is supported for get list of builds, which limits the maximum number of builds to return.
    ServiceResponse<PageImpl<BuildInner>> * @param skipToken $skipToken is supported on get list of builds, which provides the next page in the list of builds.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName, final String filter, final Integer top, final String skipToken) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, filter, top, skipToken, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the detailed information for a given build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildInner object if successful.
     */
    public BuildInner get(String resourceGroupName, String registryName, String buildId) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single().body();
    }

    /**
     * Gets the detailed information for a given build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildInner> getAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Gets the detailed information for a given build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<BuildInner> getAsync(String resourceGroupName, String registryName, String buildId) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<BuildInner>, BuildInner>() {
            @Override
            public BuildInner call(ServiceResponse<BuildInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the detailed information for a given build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<ServiceResponse<BuildInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildInner object if successful.
     */
    public BuildInner update(String resourceGroupName, String registryName, String buildId) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().last().body();
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<BuildInner>, BuildInner>() {
            @Override
            public BuildInner call(ServiceResponse<BuildInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final Boolean isArchiveEnabled = null;
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(null);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildInner>() { }.getType());
    }
    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildInner object if successful.
     */
    public BuildInner update(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).toBlocking().last().body();
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled, final ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled), serviceCallback);
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).map(new Func1<ServiceResponse<BuildInner>, BuildInner>() {
            @Override
            public BuildInner call(ServiceResponse<BuildInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<BuildInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildInner>() { }.getType());
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildInner object if successful.
     */
    public BuildInner beginUpdate(String resourceGroupName, String registryName, String buildId) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single().body();
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<BuildInner>, BuildInner>() {
            @Override
            public BuildInner call(ServiceResponse<BuildInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<ServiceResponse<BuildInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        final Boolean isArchiveEnabled = null;
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(null);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildInner object if successful.
     */
    public BuildInner beginUpdate(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).toBlocking().single().body();
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled, final ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled), serviceCallback);
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).map(new Func1<ServiceResponse<BuildInner>, BuildInner>() {
            @Override
            public BuildInner call(ServiceResponse<BuildInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Patch the build properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildInner object
     */
    public Observable<ServiceResponse<BuildInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildInner>() { }.getType())
                .register(201, new TypeToken<BuildInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a link to download the build logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BuildGetLogResultInner object if successful.
     */
    public BuildGetLogResultInner getLogLink(String resourceGroupName, String registryName, String buildId) {
        return getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single().body();
    }

    /**
     * Gets a link to download the build logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BuildGetLogResultInner> getLogLinkAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<BuildGetLogResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Gets a link to download the build logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildGetLogResultInner object
     */
    public Observable<BuildGetLogResultInner> getLogLinkAsync(String resourceGroupName, String registryName, String buildId) {
        return getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<BuildGetLogResultInner>, BuildGetLogResultInner>() {
            @Override
            public BuildGetLogResultInner call(ServiceResponse<BuildGetLogResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a link to download the build logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BuildGetLogResultInner object
     */
    public Observable<ServiceResponse<BuildGetLogResultInner>> getLogLinkWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.getLogLink(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildGetLogResultInner>>>() {
                @Override
                public Observable<ServiceResponse<BuildGetLogResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BuildGetLogResultInner> clientResponse = getLogLinkDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BuildGetLogResultInner> getLogLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BuildGetLogResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BuildGetLogResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void cancel(String resourceGroupName, String registryName, String buildId) {
        cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().last().body();
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> cancelAsync(String resourceGroupName, String registryName, String buildId) {
        return cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = service.cancel(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginCancel(String resourceGroupName, String registryName, String buildId) {
        beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single().body();
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginCancelAsync(String resourceGroupName, String registryName, String buildId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginCancelAsync(String resourceGroupName, String registryName, String buildId) {
        return beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancel an existing build.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param buildId The build ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        final String apiVersion = "2018-02-01-preview";
        return service.beginCancel(this.client.subscriptionId(), resourceGroupName, registryName, buildId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginCancelDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BuildInner&gt; object if successful.
     */
    public PagedList<BuildInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<BuildInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildInner>(response.body()) {
            @Override
            public Page<BuildInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BuildInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<BuildInner>> serviceFuture, final ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<Page<BuildInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>() {
                @Override
                public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BuildInner&gt; object
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the builds for a registry.
     *
    ServiceResponse<PageImpl<BuildInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BuildInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BuildInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BuildInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BuildInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BuildInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BuildInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BuildInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
