/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.containerregistry.ImportSource;
import java.util.List;
import com.microsoft.azure.management.containerregistry.ImportMode;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ImportImageParametersInner model.
 */
public class ImportImageParametersInner {
    /**
     * The source of the image.
     */
    @JsonProperty(value = "source", required = true)
    private ImportSource source;

    /**
     * List of strings of the form repo[:tag]. When tag is omitted the source
     * will be used (or 'latest' if source tag is also omitted).
     */
    @JsonProperty(value = "targetTags")
    private List<String> targetTags;

    /**
     * List of strings of repository names to do a manifest only copy. No tag
     * will be created.
     */
    @JsonProperty(value = "untaggedTargetRepositories")
    private List<String> untaggedTargetRepositories;

    /**
     * When Force, any existing target tags will be overwritten. When NoForce,
     * any existing target tags will fail the operation before any copying
     * begins. Possible values include: 'NoForce', 'Force'.
     */
    @JsonProperty(value = "mode")
    private ImportMode mode;

    /**
     * Get the source value.
     *
     * @return the source value
     */
    public ImportSource source() {
        return this.source;
    }

    /**
     * Set the source value.
     *
     * @param source the source value to set
     * @return the ImportImageParametersInner object itself.
     */
    public ImportImageParametersInner withSource(ImportSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the targetTags value.
     *
     * @return the targetTags value
     */
    public List<String> targetTags() {
        return this.targetTags;
    }

    /**
     * Set the targetTags value.
     *
     * @param targetTags the targetTags value to set
     * @return the ImportImageParametersInner object itself.
     */
    public ImportImageParametersInner withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    /**
     * Get the untaggedTargetRepositories value.
     *
     * @return the untaggedTargetRepositories value
     */
    public List<String> untaggedTargetRepositories() {
        return this.untaggedTargetRepositories;
    }

    /**
     * Set the untaggedTargetRepositories value.
     *
     * @param untaggedTargetRepositories the untaggedTargetRepositories value to set
     * @return the ImportImageParametersInner object itself.
     */
    public ImportImageParametersInner withUntaggedTargetRepositories(List<String> untaggedTargetRepositories) {
        this.untaggedTargetRepositories = untaggedTargetRepositories;
        return this;
    }

    /**
     * Get the mode value.
     *
     * @return the mode value
     */
    public ImportMode mode() {
        return this.mode;
    }

    /**
     * Set the mode value.
     *
     * @param mode the mode value to set
     * @return the ImportImageParametersInner object itself.
     */
    public ImportImageParametersInner withMode(ImportMode mode) {
        this.mode = mode;
        return this;
    }

}
