/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.containerregistry.QuarantinePolicy;
import com.microsoft.azure.management.containerregistry.TrustPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An object that represents policies for a container registry.
 */
public class RegistryPoliciesInner {
    /**
     * An object that represents quarantine policy for a container registry.
     */
    @JsonProperty(value = "quarantinePolicy")
    private QuarantinePolicy quarantinePolicy;

    /**
     * An object that represents content trust policy for a container registry.
     */
    @JsonProperty(value = "trustPolicy")
    private TrustPolicy trustPolicy;

    /**
     * Get the quarantinePolicy value.
     *
     * @return the quarantinePolicy value
     */
    public QuarantinePolicy quarantinePolicy() {
        return this.quarantinePolicy;
    }

    /**
     * Set the quarantinePolicy value.
     *
     * @param quarantinePolicy the quarantinePolicy value to set
     * @return the RegistryPoliciesInner object itself.
     */
    public RegistryPoliciesInner withQuarantinePolicy(QuarantinePolicy quarantinePolicy) {
        this.quarantinePolicy = quarantinePolicy;
        return this;
    }

    /**
     * Get the trustPolicy value.
     *
     * @return the trustPolicy value
     */
    public TrustPolicy trustPolicy() {
        return this.trustPolicy;
    }

    /**
     * Set the trustPolicy value.
     *
     * @param trustPolicy the trustPolicy value to set
     * @return the RegistryPoliciesInner object itself.
     */
    public RegistryPoliciesInner withTrustPolicy(TrustPolicy trustPolicy) {
        this.trustPolicy = trustPolicy;
        return this;
    }

}
