/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import java.util.Map;
import com.microsoft.azure.management.containerregistry.WebhookStatus;
import java.util.List;
import com.microsoft.azure.management.containerregistry.WebhookAction;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The parameters for creating a webhook.
 */
@JsonFlatten
public class WebhookCreateParametersInner {
    /**
     * The tags for the webhook.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * The location of the webhook. This cannot be changed after the resource
     * is created.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The service URI for the webhook to post notifications.
     */
    @JsonProperty(value = "properties.serviceUri", required = true)
    private String serviceUri;

    /**
     * Custom headers that will be added to the webhook notifications.
     */
    @JsonProperty(value = "properties.customHeaders")
    private Map<String, String> customHeaders;

    /**
     * The status of the webhook at the time the operation was called. Possible
     * values include: 'enabled', 'disabled'.
     */
    @JsonProperty(value = "properties.status")
    private WebhookStatus status;

    /**
     * The scope of repositories where the event can be triggered. For example,
     * 'foo:*' means events for all tags under repository 'foo'. 'foo:bar'
     * means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'.
     * Empty means all events.
     */
    @JsonProperty(value = "properties.scope")
    private String scope;

    /**
     * The list of actions that trigger the webhook to post notifications.
     */
    @JsonProperty(value = "properties.actions", required = true)
    private List<WebhookAction> actions;

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location value.
     *
     * @param location the location value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the serviceUri value.
     *
     * @return the serviceUri value
     */
    public String serviceUri() {
        return this.serviceUri;
    }

    /**
     * Set the serviceUri value.
     *
     * @param serviceUri the serviceUri value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    /**
     * Get the customHeaders value.
     *
     * @return the customHeaders value
     */
    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    /**
     * Set the customHeaders value.
     *
     * @param customHeaders the customHeaders value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public WebhookStatus status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the scope value.
     *
     * @return the scope value
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope value.
     *
     * @param scope the scope value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the actions value.
     *
     * @return the actions value
     */
    public List<WebhookAction> actions() {
        return this.actions;
    }

    /**
     * Set the actions value.
     *
     * @param actions the actions value to set
     * @return the WebhookCreateParametersInner object itself.
     */
    public WebhookCreateParametersInner withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

}
