/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerregistry.BuildStatus;
import com.microsoft.azure.management.containerregistry.BuildType;
import com.microsoft.azure.management.containerregistry.GitCommitTrigger;
import com.microsoft.azure.management.containerregistry.ImageDescriptor;
import com.microsoft.azure.management.containerregistry.ImageUpdateTrigger;
import com.microsoft.azure.management.containerregistry.OsType;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.implementation.BuildInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_14_0)
public interface Build
extends ExternalChildResource<Build, Registry>,
HasName,
HasId,
HasInner<BuildInner>,
Refreshable<Build>,
Updatable<Update> {
    public String buildId();

    public BuildStatus status();

    public DateTime lastUpdatedTime();

    public BuildType buildType();

    public DateTime createTime();

    public DateTime startTime();

    public DateTime finishTime();

    public List<ImageDescriptor> outputImages();

    public String buildTask();

    public ImageUpdateTrigger imageUpdateTrigger();

    public GitCommitTrigger gitCommitTrigger();

    public boolean isArchiveEnabled();

    public OsType osType();

    public int cpuCount();

    public ProvisioningState provisioningState();

    public String getLogLink();

    public Observable<String> getLogLinkAsync();

    public static interface UpdateStages {

        public static interface WithArchiving {
            public Update withArchivingEnabled();

            public Update withArchivingDisabled();
        }
    }

    public static interface Update
    extends UpdateStages.WithArchiving,
    Appliable<Build> {
    }

    public static interface QueuedQuickBuildDefinition
    extends QueuedQuickBuildDefinitionStages.Blank,
    QueuedQuickBuildDefinitionStages.WithOSType,
    QueuedQuickBuildDefinitionStages.WithSourceLocation,
    QueuedQuickBuildDefinitionStages.WithDockerFilePath,
    QueuedQuickBuildDefinitionStages.WithBuildArgument,
    QueuedQuickBuildDefinitionStages.WithCpuCoresCount,
    QueuedQuickBuildDefinitionStages.WithBuildTimeoutInSeconds,
    QueuedQuickBuildDefinitionStages.WithImageNames,
    QueuedQuickBuildDefinitionStages.WithImageCache,
    QueuedQuickBuildDefinitionStages.WithImagePush,
    QueuedQuickBuildDefinitionStages.WithCreate {
    }

    public static interface QueuedQuickBuildDefinitionStages {

        public static interface WithCreate
        extends WithBuildArgument,
        WithCpuCoresCount,
        WithBuildTimeoutInSeconds,
        WithImageNames,
        WithImageCache,
        WithImagePush,
        Creatable<Build> {
        }

        public static interface WithImagePush {
            public WithCreate withImagePushEnabled();

            public WithCreate withImagePushDisabled();
        }

        public static interface WithImageCache {
            public WithCreate withImageCacheEnabled();

            public WithCreate withImageCacheDisabled();
        }

        public static interface WithImageNames {
            public WithCreate withImageNames(String ... var1);
        }

        public static interface WithBuildTimeoutInSeconds {
            public WithCreate withBuildTimeoutInSeconds(int var1);
        }

        public static interface WithCpuCoresCount {
            public WithCreate withCpuCoresCount(int var1);
        }

        public static interface QueuedQuickBuildArgumentDefinitionStages {

            public static interface BuildArgumentDefinition<ParentT>
            extends BuildArgumentDefinitionBlank<ParentT>,
            WithValue<ParentT>,
            WithType<ParentT>,
            WithSecrecy<ParentT>,
            WithBuildArgumentAttach<ParentT> {
            }

            public static interface WithBuildArgumentAttach<ParentT>
            extends WithType<ParentT>,
            WithSecrecy<ParentT>,
            Attachable.InDefinition<ParentT> {
            }

            public static interface WithSecrecy<ParentT> {
                public WithBuildArgumentAttach<ParentT> withSecrecyEnabled();

                public WithBuildArgumentAttach<ParentT> withSecrecyDisabled();
            }

            public static interface WithType<ParentT> {
                public WithBuildArgumentAttach<ParentT> withType(String var1);
            }

            public static interface WithValue<ParentT> {
                public WithBuildArgumentAttach<ParentT> withValue(String var1);
            }

            public static interface BuildArgumentDefinitionBlank<ParentT>
            extends WithValue<ParentT> {
            }
        }

        public static interface WithBuildArgument {
            public QueuedQuickBuildArgumentDefinitionStages.BuildArgumentDefinitionBlank<WithCreate> defineBuildArgument(String var1);
        }

        public static interface WithDockerFilePath {
            public WithCreate withDockerFilePath(String var1);
        }

        public static interface WithSourceLocation {
            public WithDockerFilePath withSourceLocation(String var1);
        }

        public static interface WithOSType {
            public WithSourceLocation withOSType(OsType var1);
        }

        public static interface Blank
        extends WithOSType {
        }
    }
}

