/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerregistry.Build;
import com.microsoft.azure.management.containerregistry.BuildStepOperations;
import com.microsoft.azure.management.containerregistry.BuildTaskStatus;
import com.microsoft.azure.management.containerregistry.OsType;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.SourceControlType;
import com.microsoft.azure.management.containerregistry.TokenType;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_14_0)
public interface BuildTask
extends ExternalChildResource<BuildTask, Registry>,
Resource,
HasInner<BuildTaskInner>,
Refreshable<BuildTask>,
Updatable<Update> {
    public String parentId();

    public ProvisioningState provisioningState();

    public DateTime creationDate();

    public String alias();

    public BuildTaskStatus status();

    public int timeout();

    public OsType osType();

    public int cpuCount();

    public SourceControlType sourceControlType();

    public String repositoryUrl();

    public boolean isCommitTriggerEnabled();

    public TokenType authenticationTokenType();

    public String authenticationToken();

    public String refreshToken();

    public String scope();

    public int tokenExpirationTimeInSeconds();

    public Build queueBuildTask();

    public Observable<Build> queueBuildTaskAsync();

    @Beta(value=Beta.SinceVersion.V1_14_0)
    public BuildStepOperations buildSteps();

    public static interface UpdateStages {

        public static interface WithBuildTaskStatus {
            public Update withBuildTaskStatusEnabled();

            public Update withBuildTaskStatusDisabled();
        }

        public static interface WithBuildTimeoutInSeconds {
            public Update withBuildTimeoutInSeconds(int var1);
        }

        public static interface WithCpuCoresCount {
            public Update withCpuCoresCount(int var1);
        }

        public static interface WithCommitTrigger {
            public Update withCommitTriggerEnabled();

            public Update withCommitTriggerDisabled();
        }

        public static interface WithAuthenticationTokenAccessScope {
            public Update withAuthenticationTokenTypeAccessScope(String var1);
        }

        public static interface WithTokenExpirationTimeInSeconds {
            public Update withTokenExpirationTimeInSeconds(int var1);
        }

        public static interface WithAuthenticationRefreshToken {
            public Update withAuthenticationRefreshToken(String var1);
        }

        public static interface WithAlias {
            public Update withAlias(String var1);
        }

        public static interface WithAuthenticationToken {
            public Update withAuthenticationToken(String var1);
        }

        public static interface WithAuthenticationTokenType {
            public Update withAuthenticationTokenType(TokenType var1);
        }

        public static interface WithRepositoryUrl {
            public Update withRepositoryUrl(String var1);
        }

        public static interface WithSourceControlType {
            public Update withSourceControlType(SourceControlType var1);
        }

        public static interface WithOSType {
            public Update withOSType(OsType var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithOSType,
    UpdateStages.WithSourceControlType,
    UpdateStages.WithRepositoryUrl,
    UpdateStages.WithAuthenticationTokenType,
    UpdateStages.WithAuthenticationToken,
    UpdateStages.WithAlias,
    UpdateStages.WithAuthenticationRefreshToken,
    UpdateStages.WithTokenExpirationTimeInSeconds,
    UpdateStages.WithAuthenticationTokenAccessScope,
    UpdateStages.WithCommitTrigger,
    UpdateStages.WithCpuCoresCount,
    UpdateStages.WithBuildTimeoutInSeconds,
    UpdateStages.WithBuildTaskStatus,
    Resource.UpdateWithTags<Update>,
    Appliable<BuildTask> {
    }

    public static interface BuildTaskDefinition
    extends DefinitionStages.Blank,
    DefinitionStages.WithOSType,
    DefinitionStages.WithSourceControlType,
    DefinitionStages.WithRepositoryUrl,
    DefinitionStages.WithAuthenticationTokenType,
    DefinitionStages.WithAuthenticationToken,
    DefinitionStages.WithAlias,
    DefinitionStages.WithAuthenticationRefreshToken,
    DefinitionStages.WithTokenExpirationTimeInSeconds,
    DefinitionStages.WithAuthenticationTokenAccessScope,
    DefinitionStages.WithCommitTrigger,
    DefinitionStages.WithCpuCoresCount,
    DefinitionStages.WithBuildTimeoutInSeconds,
    DefinitionStages.WithBuildTaskStatus,
    DefinitionStages.WithCreate {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithAuthenticationRefreshToken,
        WithTokenExpirationTimeInSeconds,
        WithAuthenticationTokenAccessScope,
        WithCommitTrigger,
        WithCpuCoresCount,
        WithBuildTimeoutInSeconds,
        WithBuildTaskStatus,
        Resource.DefinitionWithTags<WithCreate>,
        Creatable<BuildTask> {
        }

        public static interface WithBuildTaskStatus {
            public WithCreate withBuildTaskStatusEnabled();

            public WithCreate withBuildTaskStatusDisabled();
        }

        public static interface WithBuildTimeoutInSeconds {
            public WithCreate withBuildTimeoutInSeconds(int var1);
        }

        public static interface WithCpuCoresCount {
            public WithCreate withCpuCoresCount(int var1);
        }

        public static interface WithCommitTrigger {
            public WithCreate withCommitTriggerEnabled();

            public WithCreate withCommitTriggerDisabled();
        }

        public static interface WithAuthenticationTokenAccessScope {
            public WithCreate withAuthenticationTokenTypeAccessScope(String var1);
        }

        public static interface WithTokenExpirationTimeInSeconds {
            public WithCreate withTokenExpirationTimeInSeconds(int var1);
        }

        public static interface WithAuthenticationRefreshToken {
            public WithCreate withAuthenticationRefreshToken(String var1);
        }

        public static interface WithAlias {
            public WithCreate withAlias(String var1);
        }

        public static interface WithAuthenticationToken {
            public WithAlias withAuthenticationToken(String var1);
        }

        public static interface WithAuthenticationTokenType {
            public WithAuthenticationToken withAuthenticationTokenType(TokenType var1);
        }

        public static interface WithRepositoryUrl {
            public WithAuthenticationTokenType withRepositoryUrl(String var1);
        }

        public static interface WithSourceControlType {
            public WithRepositoryUrl withSourceControlType(SourceControlType var1);
        }

        public static interface WithOSType {
            public WithSourceControlType withOSType(OsType var1);
        }

        public static interface Blank
        extends WithOSType {
        }
    }
}

