/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.Build;
import com.microsoft.azure.management.containerregistry.BuildStatus;
import com.microsoft.azure.management.containerregistry.BuildType;
import com.microsoft.azure.management.containerregistry.GitCommitTrigger;
import com.microsoft.azure.management.containerregistry.ImageDescriptor;
import com.microsoft.azure.management.containerregistry.ImageUpdateTrigger;
import com.microsoft.azure.management.containerregistry.OsType;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.QuickBuildRequest;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.implementation.BuildArgumentImpl;
import com.microsoft.azure.management.containerregistry.implementation.BuildGetLogResultInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class BuildImpl
extends ExternalChildResourceImpl<Build, BuildInner, RegistryImpl, Registry>
implements Build,
Build.QueuedQuickBuildDefinition,
Build.Update {
    private QuickBuildRequest quickBuildRequest;

    protected BuildImpl(String name, RegistryImpl parent, BuildInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    public QuickBuildRequest quickBuildRequest() {
        if (this.quickBuildRequest == null) {
            this.quickBuildRequest = new QuickBuildRequest();
        }
        return this.quickBuildRequest;
    }

    public String id() {
        return ((BuildInner)this.inner()).id();
    }

    @Override
    public String buildId() {
        return ((BuildInner)this.inner()).buildId();
    }

    public String name() {
        return ((BuildInner)this.inner()).buildId();
    }

    @Override
    public BuildStatus status() {
        return ((BuildInner)this.inner()).status();
    }

    @Override
    public DateTime lastUpdatedTime() {
        return ((BuildInner)this.inner()).lastUpdatedTime();
    }

    @Override
    public BuildType buildType() {
        return ((BuildInner)this.inner()).buildType();
    }

    @Override
    public DateTime createTime() {
        return ((BuildInner)this.inner()).createTime();
    }

    @Override
    public DateTime startTime() {
        return ((BuildInner)this.inner()).startTime();
    }

    @Override
    public DateTime finishTime() {
        return ((BuildInner)this.inner()).finishTime();
    }

    @Override
    public List<ImageDescriptor> outputImages() {
        List<ImageDescriptor> result = ((BuildInner)this.inner()).outputImages();
        if (result == null) {
            result = new ArrayList<ImageDescriptor>();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String buildTask() {
        return ((BuildInner)this.inner()).buildTask();
    }

    @Override
    public ImageUpdateTrigger imageUpdateTrigger() {
        return ((BuildInner)this.inner()).imageUpdateTrigger();
    }

    @Override
    public GitCommitTrigger gitCommitTrigger() {
        return ((BuildInner)this.inner()).gitCommitTrigger();
    }

    @Override
    public boolean isArchiveEnabled() {
        return ((BuildInner)this.inner()).isArchiveEnabled();
    }

    @Override
    public OsType osType() {
        if (((BuildInner)this.inner()).platform() != null) {
            return ((BuildInner)this.inner()).platform().osType();
        }
        return null;
    }

    @Override
    public int cpuCount() {
        if (((BuildInner)this.inner()).platform() != null) {
            return ((BuildInner)this.inner()).platform().cpu();
        }
        return 0;
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((BuildInner)this.inner()).provisioningState();
    }

    @Override
    public String getLogLink() {
        return (String)this.getLogLinkAsync().toBlocking().single();
    }

    @Override
    public Observable<String> getLogLinkAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).builds().getLogLinkAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.buildId()).map((Func1)new Func1<BuildGetLogResultInner, String>(){

            public String call(BuildGetLogResultInner buildGetLogResultInner) {
                return buildGetLogResultInner.logLink();
            }
        });
    }

    @Override
    public BuildImpl withArchivingEnabled() {
        ((BuildInner)this.inner()).withIsArchiveEnabled(true);
        return this;
    }

    @Override
    public BuildImpl withArchivingDisabled() {
        ((BuildInner)this.inner()).withIsArchiveEnabled(false);
        return this;
    }

    public Build.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    public Observable<Build> createResourceAsync() {
        final BuildImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).registries().queueBuildAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.quickBuildRequest).map((Func1)new Func1<BuildInner, Build>(){

            public Build call(BuildInner buildInner) {
                self.setInner(buildInner);
                return self;
            }
        });
    }

    public Observable<Build> updateResourceAsync() {
        final BuildImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).builds().updateAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.buildId(), ((BuildInner)this.inner()).isArchiveEnabled()).map((Func1)new Func1<BuildInner, Build>(){

            public Build call(BuildInner buildInner) {
                self.setInner(buildInner);
                return self;
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return null;
    }

    protected Observable<BuildInner> getInnerAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).builds().getAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.buildId());
    }

    @Override
    public BuildImpl withOSType(OsType osType) {
        this.quickBuildRequest().withIsPushEnabled(false);
        if (this.quickBuildRequest().platform() == null) {
            this.quickBuildRequest().withPlatform(new PlatformProperties());
        }
        this.quickBuildRequest().platform().withOsType(osType);
        return this;
    }

    @Override
    public BuildImpl withSourceLocation(String sourceLocation) {
        this.quickBuildRequest().withSourceLocation(sourceLocation);
        return this;
    }

    @Override
    public BuildImpl withDockerFilePath(String dockerFilePath) {
        this.quickBuildRequest().withDockerFilePath(dockerFilePath);
        return this;
    }

    public BuildArgumentImpl defineBuildArgument(String name) {
        return new BuildArgumentImpl(this, name);
    }

    @Override
    public BuildImpl withCpuCoresCount(int count) {
        if (this.quickBuildRequest().platform() == null) {
            this.quickBuildRequest().withPlatform(new PlatformProperties());
        }
        this.quickBuildRequest().platform().withCpu(count);
        return this;
    }

    @Override
    public BuildImpl withBuildTimeoutInSeconds(int buildTimeoutInSeconds) {
        this.quickBuildRequest().withTimeout(buildTimeoutInSeconds);
        return this;
    }

    @Override
    public BuildImpl withImageNames(String ... imageNames) {
        this.quickBuildRequest().withImageNames(Arrays.asList(imageNames));
        return this;
    }

    @Override
    public BuildImpl withImageCacheEnabled() {
        this.quickBuildRequest().withNoCache(false);
        return this;
    }

    @Override
    public BuildImpl withImageCacheDisabled() {
        this.quickBuildRequest().withNoCache(true);
        return this;
    }

    @Override
    public BuildImpl withImagePushEnabled() {
        this.quickBuildRequest().withIsPushEnabled(true);
        return this;
    }

    @Override
    public BuildImpl withImagePushDisabled() {
        this.quickBuildRequest().withIsPushEnabled(false);
        return this;
    }
}

