/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.BuildStep;
import com.microsoft.azure.management.containerregistry.BuildStepOperations;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepImpl;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class BuildStepOperationsImpl
implements BuildStepOperations {
    private final RegistryImpl containerRegistry;
    private final BuildTaskImpl buildTask;

    BuildStepOperationsImpl(BuildTaskImpl buildTask) {
        this.buildTask = buildTask;
        this.containerRegistry = (RegistryImpl)buildTask.parent();
    }

    @Override
    public BuildStep.BuildTaskBuildStepsDefinitionStages.Blank define(String buildStepName) {
        BuildStepImpl buildStep = new BuildStepImpl(buildStepName, this.buildTask, new BuildStepInner());
        buildStep.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return buildStep;
    }

    @Override
    public BuildStep get(String buildStepName) {
        return (BuildStep)this.getAsync(buildStepName).toBlocking().single();
    }

    @Override
    public Observable<BuildStep> getAsync(final String buildStepName) {
        final BuildStepOperationsImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildSteps().getAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), this.buildTask.name(), buildStepName).map((Func1)new Func1<BuildStepInner, BuildStep>(){

            public BuildStep call(BuildStepInner buildStepInner) {
                return new BuildStepImpl(buildStepName, self.buildTask, buildStepInner);
            }
        });
    }

    @Override
    public void delete(String buildStepName) {
        this.deleteAsync(buildStepName);
    }

    @Override
    public Completable deleteAsync(String buildStepName) {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildSteps().deleteAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), this.buildTask.name(), buildStepName).toCompletable();
    }

    @Override
    public PagedList<BuildStep> list() {
        final BuildStepOperationsImpl self = this;
        PagedListConverter<BuildStepInner, BuildStep> converter = new PagedListConverter<BuildStepInner, BuildStep>(){

            public Observable<BuildStep> typeConvertAsync(BuildStepInner inner) {
                return Observable.just((Object)new BuildStepImpl(inner.name(), self.buildTask, inner));
            }
        };
        return converter.convert(((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildSteps().list(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), this.buildTask.name()));
    }

    @Override
    public Observable<BuildStep> listAsync() {
        final BuildStepOperationsImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildSteps().listAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), this.buildTask.name()).flatMap((Func1)new Func1<Page<BuildStepInner>, Observable<BuildStepInner>>(){

            public Observable<BuildStepInner> call(Page<BuildStepInner> buildStepInnerPage) {
                return Observable.from((Iterable)buildStepInnerPage.items());
            }
        }).map((Func1)new Func1<BuildStepInner, BuildStep>(){

            public BuildStep call(BuildStepInner inner) {
                return new BuildStepImpl(inner.name(), self.buildTask, inner);
            }
        });
    }
}

