/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.implementation.BuildArgumentInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepPropertiesInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepUpdateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class BuildStepsInner {
    private BuildStepsService service;
    private ContainerRegistryManagementClientImpl client;

    public BuildStepsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (BuildStepsService)retrofit.create(BuildStepsService.class);
        this.client = client;
    }

    public PagedList<BuildStepInner> list(String resourceGroupName, String registryName, String buildTaskName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single();
        return new PagedList<BuildStepInner>((Page)response.body()){

            public Page<BuildStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildStepsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildStepInner>> listAsync(String resourceGroupName, String registryName, String buildTaskName, ListOperationCallback<BuildStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName, buildTaskName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(String nextPageLink) {
                return BuildStepsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildStepInner>> listAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map((Func1)new Func1<ServiceResponse<Page<BuildStepInner>>, Page<BuildStepInner>>(){

            public Page<BuildStepInner> call(ServiceResponse<Page<BuildStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildStepInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.listSinglePageAsync(resourceGroupName, registryName, buildTaskName).concatMap((Func1)new Func1<ServiceResponse<Page<BuildStepInner>>, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(ServiceResponse<Page<BuildStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildStepsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildStepInner>>> listSinglePageAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildStepsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildStepInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildStepInner get(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return (BuildStepInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<BuildStepInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    public Observable<BuildStepInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>(){

            public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildStepsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildStepInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildStepInner create(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return (BuildStepInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().last()).body();
    }

    public ServiceFuture<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    public Observable<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Object properties = null;
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(null);
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>(){}.getType());
    }

    public BuildStepInner create(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return (BuildStepInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).toBlocking().last()).body();
    }

    public ServiceFuture<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties), serviceCallback);
    }

    public Observable<BuildStepInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        String apiVersion = "2018-02-01-preview";
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(properties);
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>(){}.getType());
    }

    public BuildStepInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return (BuildStepInner)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    public Observable<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Object properties = null;
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(null);
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>(){

            public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildStepsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BuildStepInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return (BuildStepInner)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).toBlocking().single()).body();
    }

    public ServiceFuture<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties), serviceCallback);
    }

    public Observable<BuildStepInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, properties).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepPropertiesInner properties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        String apiVersion = "2018-02-01-preview";
        BuildStepInner buildStepCreateParameters = new BuildStepInner();
        buildStepCreateParameters.withProperties(properties);
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), buildStepCreateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>(){

            public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildStepsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildStepInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildStepInner>(){}.getType()).register(201, new TypeToken<BuildStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildStepsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildStepInner update(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return (BuildStepInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).toBlocking().last()).body();
    }

    public ServiceFuture<BuildStepInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters), serviceCallback);
    }

    public Observable<BuildStepInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (buildStepUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildStepUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)buildStepUpdateParameters);
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", buildStepUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildStepInner>(){}.getType());
    }

    public BuildStepInner beginUpdate(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return (BuildStepInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).toBlocking().single()).body();
    }

    public ServiceFuture<BuildStepInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters, ServiceCallback<BuildStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters), serviceCallback);
    }

    public Observable<BuildStepInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName, buildStepUpdateParameters).map((Func1)new Func1<ServiceResponse<BuildStepInner>, BuildStepInner>(){

            public BuildStepInner call(ServiceResponse<BuildStepInner> response) {
                return (BuildStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildStepInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, BuildStepUpdateParametersInner buildStepUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (buildStepUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildStepUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)buildStepUpdateParameters);
        String apiVersion = "2018-02-01-preview";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", buildStepUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildStepInner>>>(){

            public Observable<ServiceResponse<BuildStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildStepsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildStepInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildStepInner>(){}.getType()).register(201, new TypeToken<BuildStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BuildArgumentInner> listBuildArguments(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        ServiceResponse response = (ServiceResponse)this.listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName).toBlocking().single();
        return new PagedList<BuildArgumentInner>((Page)response.body()){

            public Page<BuildArgumentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildStepsInner.this.listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildArgumentInner>> listBuildArgumentsAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName, ListOperationCallback<BuildArgumentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(String nextPageLink) {
                return BuildStepsInner.this.listBuildArgumentsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildArgumentInner>> listBuildArgumentsAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.listBuildArgumentsWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, stepName).map((Func1)new Func1<ServiceResponse<Page<BuildArgumentInner>>, Page<BuildArgumentInner>>(){

            public Page<BuildArgumentInner> call(ServiceResponse<Page<BuildArgumentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        return this.listBuildArgumentsSinglePageAsync(resourceGroupName, registryName, buildTaskName, stepName).concatMap((Func1)new Func1<ServiceResponse<Page<BuildArgumentInner>>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(ServiceResponse<Page<BuildArgumentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildStepsInner.this.listBuildArgumentsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsSinglePageAsync(String resourceGroupName, String registryName, String buildTaskName, String stepName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.listBuildArguments(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, stepName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildStepsInner.this.listBuildArgumentsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildArgumentInner>> listBuildArgumentsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildArgumentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BuildStepInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildStepInner>((Page)response.body()){

            public Page<BuildStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildStepsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildStepInner>> listNextAsync(String nextPageLink, ServiceFuture<List<BuildStepInner>> serviceFuture, ListOperationCallback<BuildStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(String nextPageLink) {
                return BuildStepsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildStepInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BuildStepInner>>, Page<BuildStepInner>>(){

            public Page<BuildStepInner> call(ServiceResponse<Page<BuildStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildStepInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BuildStepInner>>, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(ServiceResponse<Page<BuildStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildStepsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildStepInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildStepInner>>>>(){

            public Observable<ServiceResponse<Page<BuildStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildStepsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildStepInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BuildArgumentInner> listBuildArgumentsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildArgumentInner>((Page)response.body()){

            public Page<BuildArgumentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildStepsInner.this.listBuildArgumentsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildArgumentInner>> listBuildArgumentsNextAsync(String nextPageLink, ServiceFuture<List<BuildArgumentInner>> serviceFuture, ListOperationCallback<BuildArgumentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuildArgumentsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(String nextPageLink) {
                return BuildStepsInner.this.listBuildArgumentsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildArgumentInner>> listBuildArgumentsNextAsync(String nextPageLink) {
        return this.listBuildArgumentsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BuildArgumentInner>>, Page<BuildArgumentInner>>(){

            public Page<BuildArgumentInner> call(ServiceResponse<Page<BuildArgumentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBuildArgumentsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BuildArgumentInner>>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(ServiceResponse<Page<BuildArgumentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildStepsInner.this.listBuildArgumentsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildArgumentInner>>> listBuildArgumentsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBuildArgumentsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildArgumentInner>>>>(){

            public Observable<ServiceResponse<Page<BuildArgumentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildStepsInner.this.listBuildArgumentsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildArgumentInner>> listBuildArgumentsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildArgumentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BuildStepsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BuildStepInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BuildStepInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Body BuildStepUpdateParametersInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Body BuildStepUpdateParametersInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listBuildArguments"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}/listBuildArguments")
        public Observable<Response<ResponseBody>> listBuildArguments(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Path(value="stepName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildSteps listBuildArgumentsNext"})
        @GET
        public Observable<Response<ResponseBody>> listBuildArgumentsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

