/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.Build;
import com.microsoft.azure.management.containerregistry.BuildTask;
import com.microsoft.azure.management.containerregistry.BuildTaskStatus;
import com.microsoft.azure.management.containerregistry.OsType;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.SourceControlAuthInfo;
import com.microsoft.azure.management.containerregistry.SourceControlType;
import com.microsoft.azure.management.containerregistry.TokenType;
import com.microsoft.azure.management.containerregistry.implementation.BuildStepOperationsImpl;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.SourceRepositoryPropertiesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class BuildTaskImpl
extends ExternalChildResourceImpl<BuildTask, BuildTaskInner, RegistryImpl, Registry>
implements BuildTask,
BuildTask.BuildTaskDefinition,
BuildTask.Update {
    protected BuildTaskImpl(String name, RegistryImpl parent, BuildTaskInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    public String id() {
        return ((BuildTaskInner)((Object)this.inner())).id();
    }

    public String type() {
        return ((BuildTaskInner)((Object)this.inner())).type();
    }

    public String regionName() {
        return ((BuildTaskInner)((Object)this.inner())).location();
    }

    public Region region() {
        return Region.fromName((String)((BuildTaskInner)((Object)this.inner())).location());
    }

    public Map<String, String> tags() {
        return Collections.unmodifiableMap(((BuildTaskInner)((Object)this.inner())).getTags());
    }

    @Override
    public String parentId() {
        return this.parent() != null ? ((RegistryImpl)this.parent()).id() : null;
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((BuildTaskInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public DateTime creationDate() {
        return ((BuildTaskInner)((Object)this.inner())).creationDate();
    }

    @Override
    public String alias() {
        return ((BuildTaskInner)((Object)this.inner())).alias();
    }

    @Override
    public BuildTaskStatus status() {
        return ((BuildTaskInner)((Object)this.inner())).status();
    }

    @Override
    public int timeout() {
        return ((BuildTaskInner)((Object)this.inner())).timeout();
    }

    @Override
    public OsType osType() {
        return ((BuildTaskInner)((Object)this.inner())).platform() != null ? ((BuildTaskInner)((Object)this.inner())).platform().osType() : null;
    }

    @Override
    public int cpuCount() {
        return ((BuildTaskInner)((Object)this.inner())).platform() != null ? ((BuildTaskInner)((Object)this.inner())).platform().cpu() : 0;
    }

    @Override
    public SourceControlType sourceControlType() {
        return ((BuildTaskInner)((Object)this.inner())).sourceRepository() != null ? ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlType() : null;
    }

    @Override
    public String repositoryUrl() {
        return ((BuildTaskInner)((Object)this.inner())).sourceRepository() != null ? ((BuildTaskInner)((Object)this.inner())).sourceRepository().repositoryUrl() : null;
    }

    @Override
    public boolean isCommitTriggerEnabled() {
        return ((BuildTaskInner)((Object)this.inner())).sourceRepository() != null ? ((BuildTaskInner)((Object)this.inner())).sourceRepository().isCommitTriggerEnabled() : false;
    }

    @Override
    public TokenType authenticationTokenType() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() != null && ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() != null) {
            return ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().tokenType();
        }
        return null;
    }

    @Override
    public String authenticationToken() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() != null && ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() != null) {
            return ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().token();
        }
        return null;
    }

    @Override
    public String refreshToken() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() != null && ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() != null) {
            return ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().refreshToken();
        }
        return null;
    }

    @Override
    public String scope() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() != null && ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() != null) {
            return ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().scope();
        }
        return null;
    }

    @Override
    public int tokenExpirationTimeInSeconds() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() != null && ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() != null) {
            return ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().expiresIn();
        }
        return 0;
    }

    @Override
    public Build queueBuildTask() {
        return ((RegistryImpl)this.parent()).queuedBuilds().queueBuildTask(this.name());
    }

    @Override
    public Observable<Build> queueBuildTaskAsync() {
        return ((RegistryImpl)this.parent()).queuedBuilds().queueBuildTaskAsync(this.name());
    }

    @Override
    public BuildStepOperationsImpl buildSteps() {
        return new BuildStepOperationsImpl(this);
    }

    @Override
    public BuildTaskImpl withOSType(OsType osType) {
        if (((BuildTaskInner)((Object)this.inner())).platform() == null) {
            ((BuildTaskInner)((Object)this.inner())).withPlatform(new PlatformProperties());
        }
        ((BuildTaskInner)((Object)this.inner())).platform().withOsType(osType);
        return this;
    }

    @Override
    public BuildTaskImpl withSourceControlType(SourceControlType sourceControlType) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlType(sourceControlType);
        return this;
    }

    @Override
    public BuildTaskImpl withRepositoryUrl(String repositoryUrl) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().withRepositoryUrl(repositoryUrl);
        return this;
    }

    @Override
    public BuildTaskImpl withAuthenticationTokenType(TokenType tokenType) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() == null) {
            ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlAuthProperties(new SourceControlAuthInfo());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().withTokenType(tokenType);
        return this;
    }

    @Override
    public BuildTaskImpl withAuthenticationToken(String token) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() == null) {
            ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlAuthProperties(new SourceControlAuthInfo());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().withToken(token);
        return this;
    }

    @Override
    public BuildTaskImpl withAlias(String alias) {
        ((BuildTaskInner)((Object)this.inner())).withAlias(alias);
        return this;
    }

    @Override
    public BuildTaskImpl withAuthenticationRefreshToken(String refreshToken) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() == null) {
            ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlAuthProperties(new SourceControlAuthInfo());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().withRefreshToken(refreshToken);
        return this;
    }

    @Override
    public BuildTaskImpl withTokenExpirationTimeInSeconds(int expirationTimeInSeconds) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() == null) {
            ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlAuthProperties(new SourceControlAuthInfo());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().withExpiresIn(expirationTimeInSeconds);
        return this;
    }

    @Override
    public BuildTaskImpl withAuthenticationTokenTypeAccessScope(String scope) {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties() == null) {
            ((BuildTaskInner)((Object)this.inner())).sourceRepository().withSourceControlAuthProperties(new SourceControlAuthInfo());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().sourceControlAuthProperties().withScope(scope);
        return this;
    }

    @Override
    public BuildTaskImpl withCommitTriggerEnabled() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().withIsCommitTriggerEnabled(true);
        return this;
    }

    @Override
    public BuildTaskImpl withCommitTriggerDisabled() {
        if (((BuildTaskInner)((Object)this.inner())).sourceRepository() == null) {
            ((BuildTaskInner)((Object)this.inner())).withSourceRepository(new SourceRepositoryPropertiesInner());
        }
        ((BuildTaskInner)((Object)this.inner())).sourceRepository().withIsCommitTriggerEnabled(false);
        return this;
    }

    @Override
    public BuildTaskImpl withCpuCoresCount(int count) {
        if (((BuildTaskInner)((Object)this.inner())).platform() == null) {
            ((BuildTaskInner)((Object)this.inner())).withPlatform(new PlatformProperties());
        }
        ((BuildTaskInner)((Object)this.inner())).platform().withCpu(count);
        return this;
    }

    @Override
    public BuildTaskImpl withBuildTimeoutInSeconds(int buildTimeoutInSeconds) {
        ((BuildTaskInner)((Object)this.inner())).withTimeout(buildTimeoutInSeconds);
        return this;
    }

    @Override
    public BuildTaskImpl withBuildTaskStatusEnabled() {
        ((BuildTaskInner)((Object)this.inner())).withStatus(BuildTaskStatus.ENABLED);
        return this;
    }

    @Override
    public BuildTaskImpl withBuildTaskStatusDisabled() {
        ((BuildTaskInner)((Object)this.inner())).withStatus(BuildTaskStatus.DISABLED);
        return this;
    }

    public BuildTaskImpl withTags(Map<String, String> tags) {
        if (tags != null) {
            ((BuildTaskInner)((Object)this.inner())).withTags(new HashMap());
            for (Map.Entry entry : ((BuildTaskInner)((Object)this.inner())).getTags().entrySet()) {
                ((BuildTaskInner)((Object)this.inner())).getTags().put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public BuildTaskImpl withTag(String key, String value) {
        if (key != null && value != null) {
            this.ensureValidTags().put(key, value);
        }
        return this;
    }

    public BuildTaskImpl withoutTag(String key) {
        if (key != null && ((BuildTaskInner)((Object)this.inner())).getTags() != null) {
            ((BuildTaskInner)((Object)this.inner())).getTags().remove(key);
        }
        return this;
    }

    private Map<String, String> ensureValidTags() {
        if (((BuildTaskInner)((Object)this.inner())).getTags() == null) {
            ((BuildTaskInner)((Object)this.inner())).withTags(new HashMap());
        }
        return ((BuildTaskInner)((Object)this.inner())).getTags();
    }

    public BuildTask.Update update() {
        return this;
    }

    public Observable<BuildTask> createResourceAsync() {
        final BuildTaskImpl self = this;
        ((BuildTaskInner)((Object)this.inner())).withLocation(((RegistryImpl)this.parent()).regionName());
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).buildTasks().createAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.name(), (BuildTaskInner)((Object)this.inner())).map((Func1)new Func1<BuildTaskInner, BuildTask>(){

            public BuildTask call(BuildTaskInner buildTaskInner) {
                self.setInner((Object)buildTaskInner);
                return self;
            }
        });
    }

    public Observable<BuildTask> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).buildTasks().deleteAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.name());
    }

    protected Observable<BuildTaskInner> getInnerAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)((RegistryImpl)this.parent()).manager()).inner())).buildTasks().getAsync(((RegistryImpl)this.parent()).resourceGroupName(), ((RegistryImpl)this.parent()).name(), this.name());
    }
}

