/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.BuildTask;
import com.microsoft.azure.management.containerregistry.BuildTaskOperations;
import com.microsoft.azure.management.containerregistry.SourceRepositoryProperties;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskImpl;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.SourceRepositoryPropertiesImpl;
import com.microsoft.azure.management.containerregistry.implementation.SourceRepositoryPropertiesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class BuildTaskOperationsImpl
implements BuildTaskOperations {
    private final RegistryImpl containerRegistry;

    BuildTaskOperationsImpl(RegistryImpl containerRegistry) {
        this.containerRegistry = containerRegistry;
    }

    @Override
    public BuildTask.DefinitionStages.Blank define(String buildTaskName) {
        BuildTaskImpl buildTask = new BuildTaskImpl(buildTaskName, this.containerRegistry, new BuildTaskInner());
        buildTask.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return buildTask;
    }

    @Override
    public BuildTask get(String buildTaskName) {
        return (BuildTask)this.getAsync(buildTaskName).toBlocking().single();
    }

    @Override
    public Observable<BuildTask> getAsync(final String buildTaskName) {
        final BuildTaskOperationsImpl self = this;
        if (this.containerRegistry == null) {
            return null;
        }
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().getAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), buildTaskName).map((Func1)new Func1<BuildTaskInner, BuildTask>(){

            public BuildTask call(BuildTaskInner buildTaskInner) {
                return new BuildTaskImpl(buildTaskName, self.containerRegistry, buildTaskInner);
            }
        });
    }

    @Override
    public SourceRepositoryProperties getSourceRepositoryProperties(String buildTaskName) {
        return (SourceRepositoryProperties)this.getSourceRepositoryPropertiesAsync(buildTaskName).toBlocking().single();
    }

    @Override
    public Observable<SourceRepositoryProperties> getSourceRepositoryPropertiesAsync(String buildTaskName) {
        if (this.containerRegistry == null) {
            return null;
        }
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().listSourceRepositoryPropertiesAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), buildTaskName).map((Func1)new Func1<SourceRepositoryPropertiesInner, SourceRepositoryProperties>(){

            public SourceRepositoryProperties call(SourceRepositoryPropertiesInner sourceRepositoryPropertiesInner) {
                return new SourceRepositoryPropertiesImpl(sourceRepositoryPropertiesInner);
            }
        });
    }

    @Override
    public void delete(String buildTaskName) {
        ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().delete(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), buildTaskName);
    }

    @Override
    public Completable deleteAsync(String buildTaskName) {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().deleteAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), buildTaskName).toCompletable();
    }

    @Override
    public PagedList<BuildTask> list() {
        final BuildTaskOperationsImpl self = this;
        PagedListConverter<BuildTaskInner, BuildTask> converter = new PagedListConverter<BuildTaskInner, BuildTask>(){

            public Observable<BuildTask> typeConvertAsync(BuildTaskInner inner) {
                return Observable.just((Object)new BuildTaskImpl(inner.name(), self.containerRegistry, inner));
            }
        };
        return converter.convert(((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().list(this.containerRegistry.resourceGroupName(), this.containerRegistry.name()));
    }

    @Override
    public Observable<BuildTask> listAsync() {
        final BuildTaskOperationsImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().listAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name()).flatMap((Func1)new Func1<Page<BuildTaskInner>, Observable<BuildTaskInner>>(){

            public Observable<BuildTaskInner> call(Page<BuildTaskInner> buildTaskInnerPage) {
                return Observable.from((Iterable)buildTaskInnerPage.items());
            }
        }).map((Func1)new Func1<BuildTaskInner, BuildTask>(){

            public BuildTask call(BuildTaskInner inner) {
                return new BuildTaskImpl(inner.name(), self.containerRegistry, inner);
            }
        });
    }

    @Override
    public PagedList<BuildTask> listWithFilter(String filter) {
        final BuildTaskOperationsImpl self = this;
        PagedListConverter<BuildTaskInner, BuildTask> converter = new PagedListConverter<BuildTaskInner, BuildTask>(){

            public Observable<BuildTask> typeConvertAsync(BuildTaskInner inner) {
                return Observable.just((Object)new BuildTaskImpl(inner.name(), self.containerRegistry, inner));
            }
        };
        return converter.convert(((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().list(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), filter, null));
    }

    @Override
    public Observable<BuildTask> listWithFilterAsync(String filter) {
        final BuildTaskOperationsImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.containerRegistry.manager()).inner())).buildTasks().listAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), filter, null).flatMap((Func1)new Func1<Page<BuildTaskInner>, Observable<BuildTaskInner>>(){

            public Observable<BuildTaskInner> call(Page<BuildTaskInner> buildTaskInnerPage) {
                return Observable.from((Iterable)buildTaskInnerPage.items());
            }
        }).map((Func1)new Func1<BuildTaskInner, BuildTask>(){

            public BuildTask call(BuildTaskInner inner) {
                return new BuildTaskImpl(inner.name(), self.containerRegistry, inner);
            }
        });
    }
}

