/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskUpdateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.SourceRepositoryPropertiesInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class BuildTasksInner {
    private BuildTasksService service;
    private ContainerRegistryManagementClientImpl client;

    public BuildTasksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (BuildTasksService)retrofit.create(BuildTasksService.class);
        this.client = client;
    }

    public PagedList<BuildTaskInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<BuildTaskInner>((Page)response.body()){

            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildTasksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildTaskInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                return BuildTasksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildTaskInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>(){

            public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildTasksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        String filter = null;
        String skipToken = null;
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", filter, skipToken, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildTasksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BuildTaskInner> list(String resourceGroupName, String registryName, String filter, String skipToken) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName, filter, skipToken).toBlocking().single();
        return new PagedList<BuildTaskInner>((Page)response.body()){

            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildTasksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildTaskInner>> listAsync(String resourceGroupName, String registryName, String filter, String skipToken, ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName, filter, skipToken), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                return BuildTasksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildTaskInner>> listAsync(String resourceGroupName, String registryName, String filter, String skipToken) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName, filter, skipToken).map((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>(){

            public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName, String filter, String skipToken) {
        return this.listSinglePageAsync(resourceGroupName, registryName, filter, skipToken).concatMap((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildTasksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listSinglePageAsync(String resourceGroupName, String registryName, String filter, String skipToken) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", filter, skipToken, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildTasksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildTaskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildTaskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildTaskInner get(String resourceGroupName, String registryName, String buildTaskName) {
        return (BuildTaskInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single()).body());
    }

    public ServiceFuture<BuildTaskInner> getAsync(String resourceGroupName, String registryName, String buildTaskName, ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    public Observable<BuildTaskInner> getAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map((Func1)new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>(){

            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return (BuildTaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BuildTaskInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>(){

            public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildTasksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildTaskInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildTaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildTaskInner create(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return (BuildTaskInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<BuildTaskInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters, ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters), serviceCallback);
    }

    public Observable<BuildTaskInner> createAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).map((Func1)new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>(){

            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return (BuildTaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BuildTaskInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)buildTaskCreateParameters));
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", buildTaskCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildTaskInner>(){}.getType());
    }

    public BuildTaskInner beginCreate(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return (BuildTaskInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<BuildTaskInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters, ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters), serviceCallback);
    }

    public Observable<BuildTaskInner> beginCreateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskCreateParameters).map((Func1)new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>(){

            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return (BuildTaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BuildTaskInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskInner buildTaskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)buildTaskCreateParameters));
        String apiVersion = "2018-02-01-preview";
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", buildTaskCreateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>(){

            public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildTasksInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildTaskInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildTaskInner>(){}.getType()).register(201, new TypeToken<BuildTaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName, String buildTaskName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName, String buildTaskName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildTasksInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildTaskInner update(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return (BuildTaskInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<BuildTaskInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters, ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters), serviceCallback);
    }

    public Observable<BuildTaskInner> updateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).map((Func1)new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>(){

            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return (BuildTaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BuildTaskInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)buildTaskUpdateParameters);
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", buildTaskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildTaskInner>(){}.getType());
    }

    public BuildTaskInner beginUpdate(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return (BuildTaskInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<BuildTaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters, ServiceCallback<BuildTaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters), serviceCallback);
    }

    public Observable<BuildTaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName, buildTaskUpdateParameters).map((Func1)new Func1<ServiceResponse<BuildTaskInner>, BuildTaskInner>(){

            public BuildTaskInner call(ServiceResponse<BuildTaskInner> response) {
                return (BuildTaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BuildTaskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName, BuildTaskUpdateParametersInner buildTaskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        if (buildTaskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter buildTaskUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)buildTaskUpdateParameters);
        String apiVersion = "2018-02-01-preview";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", buildTaskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildTaskInner>>>(){

            public Observable<ServiceResponse<BuildTaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildTasksInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildTaskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildTaskInner>(){}.getType()).register(201, new TypeToken<BuildTaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SourceRepositoryPropertiesInner listSourceRepositoryProperties(String resourceGroupName, String registryName, String buildTaskName) {
        return (SourceRepositoryPropertiesInner)((ServiceResponse)this.listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).toBlocking().single()).body();
    }

    public ServiceFuture<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesAsync(String resourceGroupName, String registryName, String buildTaskName, ServiceCallback<SourceRepositoryPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName), serviceCallback);
    }

    public Observable<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesAsync(String resourceGroupName, String registryName, String buildTaskName) {
        return this.listSourceRepositoryPropertiesWithServiceResponseAsync(resourceGroupName, registryName, buildTaskName).map((Func1)new Func1<ServiceResponse<SourceRepositoryPropertiesInner>, SourceRepositoryPropertiesInner>(){

            public SourceRepositoryPropertiesInner call(ServiceResponse<SourceRepositoryPropertiesInner> response) {
                return (SourceRepositoryPropertiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SourceRepositoryPropertiesInner>> listSourceRepositoryPropertiesWithServiceResponseAsync(String resourceGroupName, String registryName, String buildTaskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildTaskName == null) {
            throw new IllegalArgumentException("Parameter buildTaskName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.listSourceRepositoryProperties(this.client.subscriptionId(), resourceGroupName, registryName, buildTaskName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceRepositoryPropertiesInner>>>(){

            public Observable<ServiceResponse<SourceRepositoryPropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildTasksInner.this.listSourceRepositoryPropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SourceRepositoryPropertiesInner> listSourceRepositoryPropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SourceRepositoryPropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BuildTaskInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildTaskInner>((Page)response.body()){

            public Page<BuildTaskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildTasksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildTaskInner>> listNextAsync(String nextPageLink, ServiceFuture<List<BuildTaskInner>> serviceFuture, ListOperationCallback<BuildTaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(String nextPageLink) {
                return BuildTasksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildTaskInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Page<BuildTaskInner>>(){

            public Page<BuildTaskInner> call(ServiceResponse<Page<BuildTaskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BuildTaskInner>>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(ServiceResponse<Page<BuildTaskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildTasksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildTaskInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildTaskInner>>>>(){

            public Observable<ServiceResponse<Page<BuildTaskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildTasksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildTaskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildTaskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BuildTasksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Query(value="$skipToken") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Body BuildTaskInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Body BuildTaskInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Body BuildTaskUpdateParametersInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Body BuildTaskUpdateParametersInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks listSourceRepositoryProperties"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/listSourceRepositoryProperties")
        public Observable<Response<ResponseBody>> listSourceRepositoryProperties(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildTaskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.BuildTasks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

