/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.BuildUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.BuildGetLogResultInner;
import com.microsoft.azure.management.containerregistry.implementation.BuildInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class BuildsInner {
    private BuildsService service;
    private ContainerRegistryManagementClientImpl client;

    public BuildsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (BuildsService)retrofit.create(BuildsService.class);
        this.client = client;
    }

    public PagedList<BuildInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<BuildInner>((Page)response.body()){

            public Page<BuildInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                return BuildsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>(){

            public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        String filter = null;
        Integer top = null;
        String skipToken = null;
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", filter, top, skipToken, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BuildInner> list(String resourceGroupName, String registryName, String filter, Integer top, String skipToken) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken).toBlocking().single();
        return new PagedList<BuildInner>((Page)response.body()){

            public Page<BuildInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildInner>> listAsync(String resourceGroupName, String registryName, String filter, Integer top, String skipToken, ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                return BuildsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildInner>> listAsync(String resourceGroupName, String registryName, String filter, Integer top, String skipToken) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName, filter, top, skipToken).map((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>(){

            public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName, String filter, Integer top, String skipToken) {
        return this.listSinglePageAsync(resourceGroupName, registryName, filter, top, skipToken).concatMap((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listSinglePageAsync(String resourceGroupName, String registryName, String filter, Integer top, String skipToken) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", filter, top, skipToken, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildInner get(String resourceGroupName, String registryName, String buildId) {
        return (BuildInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single()).body();
    }

    public ServiceFuture<BuildInner> getAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<BuildInner> getAsync(String resourceGroupName, String registryName, String buildId) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>(){

            public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildInner update(String resourceGroupName, String registryName, String buildId) {
        return (BuildInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().last()).body();
    }

    public ServiceFuture<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Object isArchiveEnabled = null;
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(null);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildInner>(){}.getType());
    }

    public BuildInner update(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return (BuildInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).toBlocking().last()).body();
    }

    public ServiceFuture<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled), serviceCallback);
    }

    public Observable<BuildInner> updateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BuildInner>(){}.getType());
    }

    public BuildInner beginUpdate(String resourceGroupName, String registryName, String buildId) {
        return (BuildInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single()).body();
    }

    public ServiceFuture<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Object isArchiveEnabled = null;
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(null);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>(){

            public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BuildInner beginUpdate(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return (BuildInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).toBlocking().single()).body();
    }

    public ServiceFuture<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled), serviceCallback);
    }

    public Observable<BuildInner> beginUpdateAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, buildId, isArchiveEnabled).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        BuildUpdateParameters buildUpdateParameters = new BuildUpdateParameters();
        buildUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), buildUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>(){

            public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildInner>(){}.getType()).register(201, new TypeToken<BuildInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildGetLogResultInner getLogLink(String resourceGroupName, String registryName, String buildId) {
        return (BuildGetLogResultInner)((ServiceResponse)this.getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single()).body();
    }

    public ServiceFuture<BuildGetLogResultInner> getLogLinkAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<BuildGetLogResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<BuildGetLogResultInner> getLogLinkAsync(String resourceGroupName, String registryName, String buildId) {
        return this.getLogLinkWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<BuildGetLogResultInner>, BuildGetLogResultInner>(){

            public BuildGetLogResultInner call(ServiceResponse<BuildGetLogResultInner> response) {
                return (BuildGetLogResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildGetLogResultInner>> getLogLinkWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.getLogLink(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildGetLogResultInner>>>(){

            public Observable<ServiceResponse<BuildGetLogResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildsInner.this.getLogLinkDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildGetLogResultInner> getLogLinkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildGetLogResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancel(String resourceGroupName, String registryName, String buildId) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String registryName, String buildId) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.cancel(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginCancel(String resourceGroupName, String registryName, String buildId) {
        ((ServiceResponse)this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginCancelAsync(String resourceGroupName, String registryName, String buildId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId), serviceCallback);
    }

    public Observable<Void> beginCancelAsync(String resourceGroupName, String registryName, String buildId) {
        return this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, buildId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String resourceGroupName, String registryName, String buildId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildId == null) {
            throw new IllegalArgumentException("Parameter buildId is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.beginCancel(this.client.subscriptionId(), resourceGroupName, registryName, buildId, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BuildsInner.this.beginCancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BuildInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BuildInner>((Page)response.body()){

            public Page<BuildInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BuildsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BuildInner>> listNextAsync(String nextPageLink, ServiceFuture<List<BuildInner>> serviceFuture, ListOperationCallback<BuildInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(String nextPageLink) {
                return BuildsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BuildInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Page<BuildInner>>(){

            public Page<BuildInner> call(ServiceResponse<Page<BuildInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BuildInner>>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(ServiceResponse<Page<BuildInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BuildsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BuildInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BuildInner>>>>(){

            public Observable<ServiceResponse<Page<BuildInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BuildsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BuildInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BuildInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BuildsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Query(value="$top") Integer var6, @Query(value="$skipToken") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BuildUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BuildUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds getLogLink"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/getLogLink")
        public Observable<Response<ResponseBody>> getLogLink(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds beginCancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/cancel")
        public Observable<Response<ResponseBody>> beginCancel(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="buildId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Builds listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

