/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.RegenerateCredentialParameters;
import com.microsoft.azure.management.containerregistry.RegistryNameCheckRequest;
import com.microsoft.azure.management.containerregistry.implementation.BuildInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ImportImageParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.QueueBuildRequestInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryListCredentialsResultInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryNameStatusInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryPoliciesInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUpdateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUsageListResultInner;
import com.microsoft.azure.management.containerregistry.implementation.SourceUploadDefinitionInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RegistriesInner
implements InnerSupportsGet<RegistryInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<RegistryInner> {
    private RegistriesService service;
    private ContainerRegistryManagementClientImpl client;

    public RegistriesInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (RegistriesService)retrofit.create(RegistriesService.class);
        this.client = client;
    }

    public void importImage(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        ((ServiceResponse)this.importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> importImageAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters), serviceCallback);
    }

    public Observable<Void> importImageAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        return this.importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> importImageWithServiceResponseAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.importImage(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginImportImage(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        ((ServiceResponse)this.beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginImportImageAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters), serviceCallback);
    }

    public Observable<Void> beginImportImageAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        return this.beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginImportImageWithServiceResponseAsync(String resourceGroupName, String registryName, ImportImageParametersInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-10-01";
        return this.service.beginImportImage(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginImportImageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginImportImageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryNameStatusInner checkNameAvailability(String name) {
        return (RegistryNameStatusInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryNameStatusInner> checkNameAvailabilityAsync(String name, ServiceCallback<RegistryNameStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<RegistryNameStatusInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<RegistryNameStatusInner>, RegistryNameStatusInner>(){

            public RegistryNameStatusInner call(ServiceResponse<RegistryNameStatusInner> response) {
                return (RegistryNameStatusInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryNameStatusInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        RegistryNameCheckRequest registryNameCheckRequest = new RegistryNameCheckRequest();
        registryNameCheckRequest.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), "2017-10-01", this.client.acceptLanguage(), registryNameCheckRequest, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryNameStatusInner>>>(){

            public Observable<ServiceResponse<RegistryNameStatusInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryNameStatusInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryNameStatusInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner getByResourceGroup(String resourceGroupName, String registryName) {
        return (RegistryInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner create(String resourceGroupName, String registryName, RegistryInner registry) {
        return (RegistryInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, registry).toBlocking().last()).body());
    }

    public ServiceFuture<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryInner registry, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, registry), serviceCallback);
    }

    public Observable<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, registry).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registry == null) {
            throw new IllegalArgumentException("Parameter registry is required and cannot be null.");
        }
        Validator.validate((Object)((Object)registry));
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registry, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RegistryInner>(){}.getType());
    }

    public RegistryInner beginCreate(String resourceGroupName, String registryName, RegistryInner registry) {
        return (RegistryInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryInner registry, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry), serviceCallback);
    }

    public Observable<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registry == null) {
            throw new IllegalArgumentException("Parameter registry is required and cannot be null.");
        }
        Validator.validate((Object)((Object)registry));
        String apiVersion = "2017-10-01";
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registry, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).register(201, new TypeToken<RegistryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner update(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return (RegistryInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters), serviceCallback);
    }

    public Observable<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryUpdateParameters);
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registryUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RegistryInner>(){}.getType());
    }

    public RegistryInner beginUpdate(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return (RegistryInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters), serviceCallback);
    }

    public Observable<RegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryUpdateParameters);
        String apiVersion = "2017-10-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registryUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).register(201, new TypeToken<RegistryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listAsync(ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.list(this.client.subscriptionId(), "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryListCredentialsResultInner listCredentials(String resourceGroupName, String registryName) {
        return (RegistryListCredentialsResultInner)((ServiceResponse)this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryListCredentialsResultInner> listCredentialsAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryListCredentialsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryListCredentialsResultInner> listCredentialsAsync(String resourceGroupName, String registryName) {
        return this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryListCredentialsResultInner>, RegistryListCredentialsResultInner>(){

            public RegistryListCredentialsResultInner call(ServiceResponse<RegistryListCredentialsResultInner> response) {
                return (RegistryListCredentialsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryListCredentialsResultInner>> listCredentialsWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.listCredentials(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentialsResultInner>>>(){

            public Observable<ServiceResponse<RegistryListCredentialsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.listCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryListCredentialsResultInner> listCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryListCredentialsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryListCredentialsResultInner regenerateCredential(String resourceGroupName, String registryName, PasswordName name) {
        return (RegistryListCredentialsResultInner)((ServiceResponse)this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryListCredentialsResultInner> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name, ServiceCallback<RegistryListCredentialsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name), serviceCallback);
    }

    public Observable<RegistryListCredentialsResultInner> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name) {
        return this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).map((Func1)new Func1<ServiceResponse<RegistryListCredentialsResultInner>, RegistryListCredentialsResultInner>(){

            public RegistryListCredentialsResultInner call(ServiceResponse<RegistryListCredentialsResultInner> response) {
                return (RegistryListCredentialsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryListCredentialsResultInner>> regenerateCredentialWithServiceResponseAsync(String resourceGroupName, String registryName, PasswordName name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        RegenerateCredentialParameters regenerateCredentialParameters = new RegenerateCredentialParameters();
        regenerateCredentialParameters.withName(name);
        return this.service.regenerateCredential(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), regenerateCredentialParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentialsResultInner>>>(){

            public Observable<ServiceResponse<RegistryListCredentialsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.regenerateCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryListCredentialsResultInner> regenerateCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryListCredentialsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryUsageListResultInner listUsages(String resourceGroupName, String registryName) {
        return (RegistryUsageListResultInner)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryUsageListResultInner> listUsagesAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryUsageListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryUsageListResultInner> listUsagesAsync(String resourceGroupName, String registryName) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryUsageListResultInner>, RegistryUsageListResultInner>(){

            public RegistryUsageListResultInner call(ServiceResponse<RegistryUsageListResultInner> response) {
                return (RegistryUsageListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryUsageListResultInner>> listUsagesWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryUsageListResultInner>>>(){

            public Observable<ServiceResponse<RegistryUsageListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryUsageListResultInner> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryUsageListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryPoliciesInner listPolicies(String resourceGroupName, String registryName) {
        return (RegistryPoliciesInner)((ServiceResponse)this.listPoliciesWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryPoliciesInner> listPoliciesAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listPoliciesWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryPoliciesInner> listPoliciesAsync(String resourceGroupName, String registryName) {
        return this.listPoliciesWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>(){

            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return (RegistryPoliciesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryPoliciesInner>> listPoliciesWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2017-10-01";
        return this.service.listPolicies(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryPoliciesInner>>>(){

            public Observable<ServiceResponse<RegistryPoliciesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.listPoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryPoliciesInner> listPoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryPoliciesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryPoliciesInner updatePolicies(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return (RegistryPoliciesInner)((ServiceResponse)this.updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).toBlocking().last()).body();
    }

    public ServiceFuture<RegistryPoliciesInner> updatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters, ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters), serviceCallback);
    }

    public Observable<RegistryPoliciesInner> updatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return this.updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).map((Func1)new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>(){

            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return (RegistryPoliciesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryPoliciesInner>> updatePoliciesWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryPoliciesUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryPoliciesUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryPoliciesUpdateParameters);
        String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = this.service.updatePolicies(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registryPoliciesUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<RegistryPoliciesInner>(){}.getType());
    }

    public RegistryPoliciesInner beginUpdatePolicies(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return (RegistryPoliciesInner)((ServiceResponse)this.beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryPoliciesInner> beginUpdatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters, ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters), serviceCallback);
    }

    public Observable<RegistryPoliciesInner> beginUpdatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return this.beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).map((Func1)new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>(){

            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return (RegistryPoliciesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryPoliciesInner>> beginUpdatePoliciesWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryPoliciesUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryPoliciesUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryPoliciesUpdateParameters);
        String apiVersion = "2017-10-01";
        return this.service.beginUpdatePolicies(this.client.subscriptionId(), resourceGroupName, registryName, "2017-10-01", registryPoliciesUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryPoliciesInner>>>(){

            public Observable<ServiceResponse<RegistryPoliciesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginUpdatePoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryPoliciesInner> beginUpdatePoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryPoliciesInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BuildInner queueBuild(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        return (BuildInner)((ServiceResponse)this.queueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest).toBlocking().last()).body();
    }

    public ServiceFuture<BuildInner> queueBuildAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.queueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest), serviceCallback);
    }

    public Observable<BuildInner> queueBuildAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        return this.queueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> queueBuildWithServiceResponseAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildRequest == null) {
            throw new IllegalArgumentException("Parameter buildRequest is required and cannot be null.");
        }
        Validator.validate((Object)buildRequest);
        String apiVersion = "2018-02-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.queueBuild(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", buildRequest, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<BuildInner>(){}.getType());
    }

    public BuildInner beginQueueBuild(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        return (BuildInner)((ServiceResponse)this.beginQueueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest).toBlocking().single()).body();
    }

    public ServiceFuture<BuildInner> beginQueueBuildAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest, ServiceCallback<BuildInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginQueueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest), serviceCallback);
    }

    public Observable<BuildInner> beginQueueBuildAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        return this.beginQueueBuildWithServiceResponseAsync(resourceGroupName, registryName, buildRequest).map((Func1)new Func1<ServiceResponse<BuildInner>, BuildInner>(){

            public BuildInner call(ServiceResponse<BuildInner> response) {
                return (BuildInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BuildInner>> beginQueueBuildWithServiceResponseAsync(String resourceGroupName, String registryName, QueueBuildRequestInner buildRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (buildRequest == null) {
            throw new IllegalArgumentException("Parameter buildRequest is required and cannot be null.");
        }
        Validator.validate((Object)buildRequest);
        String apiVersion = "2018-02-01-preview";
        return this.service.beginQueueBuild(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", buildRequest, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BuildInner>>>(){

            public Observable<ServiceResponse<BuildInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginQueueBuildDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BuildInner> beginQueueBuildDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BuildInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SourceUploadDefinitionInner getBuildSourceUploadUrl(String resourceGroupName, String registryName) {
        return (SourceUploadDefinitionInner)((ServiceResponse)this.getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<SourceUploadDefinitionInner> getBuildSourceUploadUrlAsync(String resourceGroupName, String registryName, ServiceCallback<SourceUploadDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<SourceUploadDefinitionInner> getBuildSourceUploadUrlAsync(String resourceGroupName, String registryName) {
        return this.getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<SourceUploadDefinitionInner>, SourceUploadDefinitionInner>(){

            public SourceUploadDefinitionInner call(ServiceResponse<SourceUploadDefinitionInner> response) {
                return (SourceUploadDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SourceUploadDefinitionInner>> getBuildSourceUploadUrlWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-02-01-preview";
        return this.service.getBuildSourceUploadUrl(this.client.subscriptionId(), resourceGroupName, registryName, "2018-02-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceUploadDefinitionInner>>>(){

            public Observable<ServiceResponse<SourceUploadDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.getBuildSourceUploadUrlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SourceUploadDefinitionInner> getBuildSourceUploadUrlDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SourceUploadDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<RegistryInner>> serviceFuture, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RegistryInner>> serviceFuture, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RegistriesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries importImage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importImage")
        public Observable<Response<ResponseBody>> importImage(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body ImportImageParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginImportImage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importImage")
        public Observable<Response<ResponseBody>> beginImportImage(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body ImportImageParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body RegistryNameCheckRequest var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/registries")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listCredentials"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listCredentials")
        public Observable<Response<ResponseBody>> listCredentials(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries regenerateCredential"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/regenerateCredential")
        public Observable<Response<ResponseBody>> regenerateCredential(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegenerateCredentialParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listUsages"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listUsages")
        public Observable<Response<ResponseBody>> listUsages(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listPolicies"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listPolicies")
        public Observable<Response<ResponseBody>> listPolicies(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries updatePolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/updatePolicies")
        public Observable<Response<ResponseBody>> updatePolicies(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryPoliciesInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginUpdatePolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/updatePolicies")
        public Observable<Response<ResponseBody>> beginUpdatePolicies(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryPoliciesInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries queueBuild"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/queueBuild")
        public Observable<Response<ResponseBody>> queueBuild(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body QueueBuildRequestInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginQueueBuild"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/queueBuild")
        public Observable<Response<ResponseBody>> beginQueueBuild(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body QueueBuildRequestInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries getBuildSourceUploadUrl"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/getBuildSourceUploadUrl")
        public Observable<Response<ResponseBody>> getBuildSourceUploadUrl(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

