/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.AccessKeyType;
import com.microsoft.azure.management.containerregistry.BuildTaskOperations;
import com.microsoft.azure.management.containerregistry.QueuedBuildOperations;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.RegistryCredentials;
import com.microsoft.azure.management.containerregistry.RegistryUsage;
import com.microsoft.azure.management.containerregistry.Sku;
import com.microsoft.azure.management.containerregistry.SkuName;
import com.microsoft.azure.management.containerregistry.SourceUploadDefinition;
import com.microsoft.azure.management.containerregistry.StorageAccountProperties;
import com.microsoft.azure.management.containerregistry.WebhookOperations;
import com.microsoft.azure.management.containerregistry.implementation.BuildTaskOperationsImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.QueuedBuildOperationsImpl;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUpdateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.SourceUploadDefinitionImpl;
import com.microsoft.azure.management.containerregistry.implementation.SourceUploadDefinitionInner;
import com.microsoft.azure.management.containerregistry.implementation.WebhookImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookOperationsImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.Collection;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class RegistryImpl
extends GroupableResourceImpl<Registry, RegistryInner, RegistryImpl, ContainerRegistryManager>
implements Registry,
Registry.Definition,
Registry.Update {
    private RegistryUpdateParametersInner updateParameters;
    private final StorageManager storageManager;
    private String storageAccountId;
    private String creatableStorageAccountKey;
    private WebhooksImpl webhooks;
    private QueuedBuildOperations queuedBuilds;
    private BuildTaskOperations buildTasks;

    protected RegistryImpl(String name, RegistryInner innerObject, ContainerRegistryManager manager, StorageManager storageManager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.storageManager = storageManager;
        this.storageAccountId = null;
        this.webhooks = new WebhooksImpl(this, "Webhook");
    }

    protected Observable<RegistryInner> getInnerAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public RegistryImpl update() {
        this.updateParameters = new RegistryUpdateParametersInner();
        return (RegistryImpl)super.update();
    }

    public Observable<Registry> createResourceAsync() {
        RegistryImpl self = this;
        if (this.isInCreateMode()) {
            if (self.creatableStorageAccountKey != null) {
                StorageAccount storageAccount = (StorageAccount)self.taskResult(this.creatableStorageAccountKey);
                ((RegistryInner)((Object)self.inner())).storageAccount().withId(storageAccount.id());
            } else if (this.storageAccountId != null) {
                ((RegistryInner)((Object)self.inner())).storageAccount().withId(this.storageAccountId);
            }
            return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().createAsync(self.resourceGroupName(), self.name(), (RegistryInner)((Object)self.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        this.updateParameters.withTags(((RegistryInner)((Object)this.inner())).getTags());
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().updateAsync(self.resourceGroupName(), self.name(), self.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        this.webhooks.clear();
        return Completable.complete();
    }

    @Override
    public Sku sku() {
        return ((RegistryInner)((Object)this.inner())).sku();
    }

    @Override
    public String loginServerUrl() {
        return ((RegistryInner)((Object)this.inner())).loginServer();
    }

    @Override
    public DateTime creationDate() {
        return ((RegistryInner)((Object)this.inner())).creationDate();
    }

    @Override
    public boolean adminUserEnabled() {
        return ((RegistryInner)((Object)this.inner())).adminUserEnabled();
    }

    @Override
    public String storageAccountName() {
        if (((RegistryInner)((Object)this.inner())).storageAccount() == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)((RegistryInner)((Object)this.inner())).storageAccount().id());
    }

    @Override
    public String storageAccountId() {
        if (((RegistryInner)((Object)this.inner())).storageAccount() == null) {
            return null;
        }
        return ((RegistryInner)((Object)this.inner())).storageAccount().id();
    }

    @Override
    public RegistryImpl withClassicSku() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.CLASSIC));
            ((RegistryInner)((Object)this.inner())).withStorageAccount(new StorageAccountProperties());
        }
        return this;
    }

    @Override
    public RegistryImpl withBasicSku() {
        return this.setManagedSku(new Sku().withName(SkuName.BASIC));
    }

    @Override
    public RegistryImpl withStandardSku() {
        return this.setManagedSku(new Sku().withName(SkuName.STANDARD));
    }

    @Override
    public RegistryImpl withPremiumSku() {
        return this.setManagedSku(new Sku().withName(SkuName.PREMIUM));
    }

    private RegistryImpl setManagedSku(Sku sku) {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.inner())).withSku(sku);
            ((RegistryInner)((Object)this.inner())).withStorageAccount(null);
        } else {
            this.updateParameters.withSku(sku);
            this.updateParameters.withStorageAccount(null);
        }
        return this;
    }

    @Override
    public RegistryImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccountId = storageAccount.id();
        return this;
    }

    @Override
    public RegistryImpl withExistingStorageAccount(String id) {
        this.storageAccountId = id;
        return this;
    }

    @Override
    public RegistryImpl withNewStorageAccount(String storageAccountName) {
        this.storageAccountId = null;
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(storageAccountName)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public RegistryImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        this.storageAccountId = null;
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public RegistryImpl withRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.inner())).withAdminUserEnabled(true);
        } else {
            this.updateParameters.withAdminUserEnabled(true);
        }
        return this;
    }

    @Override
    public RegistryImpl withoutRegistryNameAsAdminUser() {
        if (this.isInCreateMode()) {
            ((RegistryInner)((Object)this.inner())).withAdminUserEnabled(false);
        } else {
            this.updateParameters.withAdminUserEnabled(false);
        }
        return this;
    }

    @Override
    public RegistryCredentials getCredentials() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentials(this.resourceGroupName(), this.name());
    }

    @Override
    public Observable<RegistryCredentials> getCredentialsAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().getCredentialsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public RegistryCredentials regenerateCredential(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredential(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Observable<RegistryCredentials> regenerateCredentialAsync(AccessKeyType accessKeyType) {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().regenerateCredentialAsync(this.resourceGroupName(), this.name(), accessKeyType);
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsages(this.resourceGroupName(), this.name());
    }

    @Override
    public Observable<RegistryUsage> listQuotaUsagesAsync() {
        return ((ContainerRegistryManager)this.manager()).containerRegistries().listQuotaUsagesAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public WebhookOperations webhooks() {
        return new WebhookOperationsImpl(this);
    }

    @Override
    public QueuedBuildOperations queuedBuilds() {
        if (this.queuedBuilds == null) {
            this.queuedBuilds = new QueuedBuildOperationsImpl(this);
        }
        return this.queuedBuilds;
    }

    @Override
    public BuildTaskOperations buildTasks() {
        if (this.buildTasks == null) {
            this.buildTasks = new BuildTaskOperationsImpl(this);
        }
        return this.buildTasks;
    }

    @Override
    public SourceUploadDefinition getBuildSourceUploadUrl() {
        return (SourceUploadDefinition)this.getBuildSourceUploadUrlAsync().toBlocking().single();
    }

    @Override
    public Observable<SourceUploadDefinition> getBuildSourceUploadUrlAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)((ContainerRegistryManager)this.manager()).inner())).registries().getBuildSourceUploadUrlAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<SourceUploadDefinitionInner, SourceUploadDefinition>(){

            public SourceUploadDefinition call(SourceUploadDefinitionInner sourceUploadDefinitionInner) {
                return new SourceUploadDefinitionImpl(sourceUploadDefinitionInner);
            }
        });
    }

    @Override
    public RegistryImpl withoutWebhook(String name) {
        this.webhooks.withoutWebhook(name);
        return this;
    }

    public WebhookImpl updateWebhook(String name) {
        return this.webhooks.updateWebhook(name);
    }

    public WebhookImpl defineWebhook(String name) {
        return this.webhooks.defineWebhook(name);
    }
}

