/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The parameters of a storage account for a container registry.
 */
public class StorageAccountParameters {
    /**
     * The name of the storage account.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The access key to the storage account.
     */
    @JsonProperty(value = "accessKey", required = true)
    private String accessKey;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the StorageAccountParameters object itself.
     */
    public StorageAccountParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessKey value.
     *
     * @return the accessKey value
     */
    public String accessKey() {
        return this.accessKey;
    }

    /**
     * Set the accessKey value.
     *
     * @param accessKey the accessKey value to set
     * @return the StorageAccountParameters object itself.
     */
    public StorageAccountParameters withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

}
