/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonSubTypes;

/**
 * Base properties for updating any task step.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("TaskStepUpdateParameters")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Docker", value = DockerBuildStepUpdateParameters.class),
    @JsonSubTypes.Type(name = "FileTask", value = FileTaskStepUpdateParameters.class),
    @JsonSubTypes.Type(name = "EncodedTask", value = EncodedTaskStepUpdateParameters.class)
})
public class TaskStepUpdateParameters {
    /**
     * The URL(absolute or relative) of the source context for the task step.
     */
    @JsonProperty(value = "contextPath")
    private String contextPath;

    /**
     * Get the URL(absolute or relative) of the source context for the task step.
     *
     * @return the contextPath value
     */
    public String contextPath() {
        return this.contextPath;
    }

    /**
     * Set the URL(absolute or relative) of the source context for the task step.
     *
     * @param contextPath the contextPath value to set
     * @return the TaskStepUpdateParameters object itself.
     */
    public TaskStepUpdateParameters withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

}
