/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.containerregistry.TaskUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Tasks.
 */
public class TasksInner {
    /** The Retrofit service to perform REST calls. */
    private TasksService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of TasksInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public TasksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(TasksService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Tasks to be
     * used by Retrofit to perform actually REST calls.
     */
    interface TasksService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Body TaskInner taskCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Body TaskInner taskCreateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Body TaskUpdateParameters taskUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Body TaskUpdateParameters taskUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks getDetails" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}/listDetails")
        Observable<Response<ResponseBody>> getDetails(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Path("taskName") String taskName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;TaskInner&gt; object if successful.
     */
    public PagedList<TaskInner> list(final String resourceGroupName, final String registryName) {
        ServiceResponse<Page<TaskInner>> response = listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<TaskInner>(response.body()) {
            @Override
            public Page<TaskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<TaskInner>> listAsync(final String resourceGroupName, final String registryName, final ListOperationCallback<TaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, registryName),
            new Func1<String, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TaskInner&gt; object
     */
    public Observable<Page<TaskInner>> listAsync(final String resourceGroupName, final String registryName) {
        return listWithServiceResponseAsync(resourceGroupName, registryName)
            .map(new Func1<ServiceResponse<Page<TaskInner>>, Page<TaskInner>>() {
                @Override
                public Page<TaskInner> call(ServiceResponse<Page<TaskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TaskInner&gt; object
     */
    public Observable<ServiceResponse<Page<TaskInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String registryName) {
        return listSinglePageAsync(resourceGroupName, registryName)
            .concatMap(new Func1<ServiceResponse<Page<TaskInner>>, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(ServiceResponse<Page<TaskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
    ServiceResponse<PageImpl<TaskInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
    ServiceResponse<PageImpl<TaskInner>> * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;TaskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<TaskInner>>> listSinglePageAsync(final String resourceGroupName, final String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        return service.list(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<TaskInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<TaskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<TaskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<TaskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<TaskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the properties of a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner get(String resourceGroupName, String registryName, String taskName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single().body();
    }

    /**
     * Get the properties of a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> getAsync(String resourceGroupName, String registryName, String taskName, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    /**
     * Get the properties of a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<TaskInner> getAsync(String resourceGroupName, String registryName, String taskName) {
        return getWithServiceResponseAsync(resourceGroupName, registryName, taskName).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the properties of a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<ServiceResponse<TaskInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        return service.get(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>() {
                @Override
                public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TaskInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TaskInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner create(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).toBlocking().last().body();
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> createAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters), serviceCallback);
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<TaskInner> createAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<TaskInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter taskCreateParameters is required and cannot be null.");
        }
        Validator.validate(taskCreateParameters);
        final String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, taskCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TaskInner>() { }.getType());
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner beginCreate(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).toBlocking().single().body();
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> beginCreateAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters), serviceCallback);
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<TaskInner> beginCreateAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a task for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskCreateParameters The parameters for creating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<ServiceResponse<TaskInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter taskCreateParameters is required and cannot be null.");
        }
        Validator.validate(taskCreateParameters);
        final String apiVersion = "2018-09-01";
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, taskCreateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>() {
                @Override
                public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TaskInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TaskInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TaskInner>() { }.getType())
                .register(201, new TypeToken<TaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName, String taskName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().last().body();
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String taskName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String taskName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName, String taskName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single().body();
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a specified task.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner update(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> updateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters), serviceCallback);
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<TaskInner> updateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<TaskInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter taskUpdateParameters is required and cannot be null.");
        }
        Validator.validate(taskUpdateParameters);
        final String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, taskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TaskInner>() { }.getType());
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner beginUpdate(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters), serviceCallback);
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<TaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a task with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param taskUpdateParameters The parameters for updating a task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<ServiceResponse<TaskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter taskUpdateParameters is required and cannot be null.");
        }
        Validator.validate(taskUpdateParameters);
        final String apiVersion = "2018-09-01";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, taskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>() {
                @Override
                public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TaskInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TaskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TaskInner>() { }.getType())
                .register(201, new TypeToken<TaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Returns a task with extended information that includes all secrets.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the TaskInner object if successful.
     */
    public TaskInner getDetails(String resourceGroupName, String registryName, String taskName) {
        return getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single().body();
    }

    /**
     * Returns a task with extended information that includes all secrets.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<TaskInner> getDetailsAsync(String resourceGroupName, String registryName, String taskName, final ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    /**
     * Returns a task with extended information that includes all secrets.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<TaskInner> getDetailsAsync(String resourceGroupName, String registryName, String taskName) {
        return getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName).map(new Func1<ServiceResponse<TaskInner>, TaskInner>() {
            @Override
            public TaskInner call(ServiceResponse<TaskInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns a task with extended information that includes all secrets.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param taskName The name of the container registry task.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the TaskInner object
     */
    public Observable<ServiceResponse<TaskInner>> getDetailsWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        return service.getDetails(this.client.subscriptionId(), resourceGroupName, registryName, taskName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>() {
                @Override
                public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<TaskInner> clientResponse = getDetailsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<TaskInner> getDetailsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<TaskInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<TaskInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;TaskInner&gt; object if successful.
     */
    public PagedList<TaskInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<TaskInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TaskInner>(response.body()) {
            @Override
            public Page<TaskInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<TaskInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<TaskInner>> serviceFuture, final ListOperationCallback<TaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TaskInner&gt; object
     */
    public Observable<Page<TaskInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<TaskInner>>, Page<TaskInner>>() {
                @Override
                public Page<TaskInner> call(ServiceResponse<Page<TaskInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;TaskInner&gt; object
     */
    public Observable<ServiceResponse<Page<TaskInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<TaskInner>>, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(ServiceResponse<Page<TaskInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the tasks for a specified container registry.
     *
    ServiceResponse<PageImpl<TaskInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;TaskInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<TaskInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TaskInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<TaskInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<TaskInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<TaskInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<TaskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<TaskInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<TaskInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
