/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ImportSourceCredentials model.
 */
public class ImportSourceCredentials {
    /**
     * The username to authenticate with the source registry.
     */
    @JsonProperty(value = "username")
    private String username;

    /**
     * The password used to authenticate with the source registry.
     */
    @JsonProperty(value = "password", required = true)
    private String password;

    /**
     * Get the username to authenticate with the source registry.
     *
     * @return the username value
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username to authenticate with the source registry.
     *
     * @param username the username value to set
     * @return the ImportSourceCredentials object itself.
     */
    public ImportSourceCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password used to authenticate with the source registry.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password used to authenticate with the source registry.
     *
     * @param password the password value to set
     * @return the ImportSourceCredentials object itself.
     */
    public ImportSourceCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

}
