/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.containerregistry.ImportImageParameters;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.RegenerateCredentialParameters;
import com.microsoft.azure.management.containerregistry.RegistryNameCheckRequest;
import com.microsoft.azure.management.containerregistry.RegistryUpdateParameters;
import com.microsoft.azure.management.containerregistry.RunRequest;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Registries.
 */
public class RegistriesInner implements InnerSupportsGet<RegistryInner>, InnerSupportsDelete<Void>, InnerSupportsListing<RegistryInner> {
    /** The Retrofit service to perform REST calls. */
    private RegistriesService service;
    /** The service client containing this operation class. */
    private ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of RegistriesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RegistriesInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = retrofit.create(RegistriesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Registries to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RegistriesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries importImage" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importImage")
        Observable<Response<ResponseBody>> importImage(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body ImportImageParameters parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginImportImage" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importImage")
        Observable<Response<ResponseBody>> beginImportImage(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body ImportImageParameters parameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries checkNameAvailability" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/checkNameAvailability")
        Observable<Response<ResponseBody>> checkNameAvailability(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegistryNameCheckRequest registryNameCheckRequest, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        Observable<Response<ResponseBody>> create(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryInner registry, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryInner registry, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryUpdateParameters registryUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryUpdateParameters registryUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/registries")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listCredentials" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listCredentials")
        Observable<Response<ResponseBody>> listCredentials(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries regenerateCredential" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/regenerateCredential")
        Observable<Response<ResponseBody>> regenerateCredential(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RegenerateCredentialParameters regenerateCredentialParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listUsages")
        Observable<Response<ResponseBody>> listUsages(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listPolicies" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listPolicies")
        Observable<Response<ResponseBody>> listPolicies(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries updatePolicies" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/updatePolicies")
        Observable<Response<ResponseBody>> updatePolicies(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryPoliciesInner registryPoliciesUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginUpdatePolicies" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/updatePolicies")
        Observable<Response<ResponseBody>> beginUpdatePolicies(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RegistryPoliciesInner registryPoliciesUpdateParameters, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries scheduleRun" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scheduleRun")
        Observable<Response<ResponseBody>> scheduleRun(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RunRequest runRequest, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginScheduleRun" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scheduleRun")
        Observable<Response<ResponseBody>> beginScheduleRun(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Body RunRequest runRequest, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries getBuildSourceUploadUrl" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listBuildSourceUploadUrl")
        Observable<Response<ResponseBody>> getBuildSourceUploadUrl(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("registryName") String registryName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void importImage(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).toBlocking().last().body();
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> importImageAsync(String resourceGroupName, String registryName, ImportImageParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters), serviceCallback);
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> importImageAsync(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        return importImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> importImageWithServiceResponseAsync(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = service.importImage(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginImportImage(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).toBlocking().single().body();
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginImportImageAsync(String resourceGroupName, String registryName, ImportImageParameters parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters), serviceCallback);
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginImportImageAsync(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        return beginImportImageWithServiceResponseAsync(resourceGroupName, registryName, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Copies an image to this container registry from the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param parameters The parameters specifying the image to copy and the source container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginImportImageWithServiceResponseAsync(String resourceGroupName, String registryName, ImportImageParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01";
        return service.beginImportImage(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, parameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginImportImageDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginImportImageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Checks whether the container registry name is available for use. The name must contain only alphanumeric characters, be globally unique, and between 5 and 50 characters in length.
     *
     * @param name The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryNameStatusInner object if successful.
     */
    public RegistryNameStatusInner checkNameAvailability(String name) {
        return checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single().body();
    }

    /**
     * Checks whether the container registry name is available for use. The name must contain only alphanumeric characters, be globally unique, and between 5 and 50 characters in length.
     *
     * @param name The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryNameStatusInner> checkNameAvailabilityAsync(String name, final ServiceCallback<RegistryNameStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    /**
     * Checks whether the container registry name is available for use. The name must contain only alphanumeric characters, be globally unique, and between 5 and 50 characters in length.
     *
     * @param name The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryNameStatusInner object
     */
    public Observable<RegistryNameStatusInner> checkNameAvailabilityAsync(String name) {
        return checkNameAvailabilityWithServiceResponseAsync(name).map(new Func1<ServiceResponse<RegistryNameStatusInner>, RegistryNameStatusInner>() {
            @Override
            public RegistryNameStatusInner call(ServiceResponse<RegistryNameStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the container registry name is available for use. The name must contain only alphanumeric characters, be globally unique, and between 5 and 50 characters in length.
     *
     * @param name The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryNameStatusInner object
     */
    public Observable<ServiceResponse<RegistryNameStatusInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        RegistryNameCheckRequest registryNameCheckRequest = new RegistryNameCheckRequest();
        registryNameCheckRequest.withName(name);
        return service.checkNameAvailability(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), registryNameCheckRequest, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryNameStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryNameStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryNameStatusInner> clientResponse = checkNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryNameStatusInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryNameStatusInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryNameStatusInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the properties of the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryInner object if successful.
     */
    public RegistryInner getByResourceGroup(String resourceGroupName, String registryName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Gets the properties of the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName, final ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Gets the properties of the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<RegistryInner>, RegistryInner>() {
            @Override
            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the properties of the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<ServiceResponse<RegistryInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryInner object if successful.
     */
    public RegistryInner create(String resourceGroupName, String registryName, RegistryInner registry) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, registry).toBlocking().last().body();
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryInner registry, final ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, registryName, registry), serviceCallback);
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        return createWithServiceResponseAsync(resourceGroupName, registryName, registry).map(new Func1<ServiceResponse<RegistryInner>, RegistryInner>() {
            @Override
            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RegistryInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registry == null) {
            throw new IllegalArgumentException("Parameter registry is required and cannot be null.");
        }
        Validator.validate(registry);
        final String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = service.create(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registry, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RegistryInner>() { }.getType());
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryInner object if successful.
     */
    public RegistryInner beginCreate(String resourceGroupName, String registryName, RegistryInner registry) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry).toBlocking().single().body();
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryInner registry, final ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry), serviceCallback);
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registry).map(new Func1<ServiceResponse<RegistryInner>, RegistryInner>() {
            @Override
            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registry The parameters for creating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<ServiceResponse<RegistryInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryInner registry) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registry == null) {
            throw new IllegalArgumentException("Parameter registry is required and cannot be null.");
        }
        Validator.validate(registry);
        final String apiVersion = "2017-10-01";
        return service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registry, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryInner>() { }.getType())
                .register(201, new TypeToken<RegistryInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String registryName) {
        deleteWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().last().body();
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String registryName) {
        return deleteWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = service.delete(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String registryName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryInner object if successful.
     */
    public RegistryInner update(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters, final ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters), serviceCallback);
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        return updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).map(new Func1<ServiceResponse<RegistryInner>, RegistryInner>() {
            @Override
            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RegistryInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryUpdateParameters is required and cannot be null.");
        }
        Validator.validate(registryUpdateParameters);
        final String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registryUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RegistryInner>() { }.getType());
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryInner object if successful.
     */
    public RegistryInner beginUpdate(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters, final ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters), serviceCallback);
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<RegistryInner> beginUpdateAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).map(new Func1<ServiceResponse<RegistryInner>, RegistryInner>() {
            @Override
            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryUpdateParameters The parameters for updating a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryInner object
     */
    public Observable<ServiceResponse<RegistryInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryUpdateParameters registryUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryUpdateParameters is required and cannot be null.");
        }
        Validator.validate(registryUpdateParameters);
        final String apiVersion = "2017-10-01";
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registryUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryInner>() { }.getType())
                .register(201, new TypeToken<RegistryInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RegistryInner&gt; object if successful.
     */
    public PagedList<RegistryInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<RegistryInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RegistryInner>(response.body()) {
            @Override
            public Page<RegistryInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RegistryInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<Page<RegistryInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>() {
                @Override
                public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
    ServiceResponse<PageImpl<RegistryInner>> * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RegistryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RegistryInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RegistryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RegistryInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RegistryInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RegistryInner&gt; object if successful.
     */
    public PagedList<RegistryInner> list() {
        ServiceResponse<Page<RegistryInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<RegistryInner>(response.body()) {
            @Override
            public Page<RegistryInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RegistryInner>> listAsync(final ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<Page<RegistryInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>() {
                @Override
                public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RegistryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RegistryInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RegistryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RegistryInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RegistryInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryListCredentialsResultInner object if successful.
     */
    public RegistryListCredentialsResultInner listCredentials(String resourceGroupName, String registryName) {
        return listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Lists the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryListCredentialsResultInner> listCredentialsAsync(String resourceGroupName, String registryName, final ServiceCallback<RegistryListCredentialsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listCredentialsWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Lists the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryListCredentialsResultInner object
     */
    public Observable<RegistryListCredentialsResultInner> listCredentialsAsync(String resourceGroupName, String registryName) {
        return listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<RegistryListCredentialsResultInner>, RegistryListCredentialsResultInner>() {
            @Override
            public RegistryListCredentialsResultInner call(ServiceResponse<RegistryListCredentialsResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryListCredentialsResultInner object
     */
    public Observable<ServiceResponse<RegistryListCredentialsResultInner>> listCredentialsWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.listCredentials(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentialsResultInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryListCredentialsResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryListCredentialsResultInner> clientResponse = listCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryListCredentialsResultInner> listCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryListCredentialsResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryListCredentialsResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Regenerates one of the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param name Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'password', 'password2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryListCredentialsResultInner object if successful.
     */
    public RegistryListCredentialsResultInner regenerateCredential(String resourceGroupName, String registryName, PasswordName name) {
        return regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).toBlocking().single().body();
    }

    /**
     * Regenerates one of the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param name Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'password', 'password2'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryListCredentialsResultInner> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name, final ServiceCallback<RegistryListCredentialsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name), serviceCallback);
    }

    /**
     * Regenerates one of the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param name Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'password', 'password2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryListCredentialsResultInner object
     */
    public Observable<RegistryListCredentialsResultInner> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name) {
        return regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).map(new Func1<ServiceResponse<RegistryListCredentialsResultInner>, RegistryListCredentialsResultInner>() {
            @Override
            public RegistryListCredentialsResultInner call(ServiceResponse<RegistryListCredentialsResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Regenerates one of the login credentials for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param name Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'password', 'password2'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryListCredentialsResultInner object
     */
    public Observable<ServiceResponse<RegistryListCredentialsResultInner>> regenerateCredentialWithServiceResponseAsync(String resourceGroupName, String registryName, PasswordName name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        RegenerateCredentialParameters regenerateCredentialParameters = new RegenerateCredentialParameters();
        regenerateCredentialParameters.withName(name);
        return service.regenerateCredential(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), regenerateCredentialParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentialsResultInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryListCredentialsResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryListCredentialsResultInner> clientResponse = regenerateCredentialDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryListCredentialsResultInner> regenerateCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryListCredentialsResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryListCredentialsResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the quota usages for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryUsageListResultInner object if successful.
     */
    public RegistryUsageListResultInner listUsages(String resourceGroupName, String registryName) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Gets the quota usages for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryUsageListResultInner> listUsagesAsync(String resourceGroupName, String registryName, final ServiceCallback<RegistryUsageListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(listUsagesWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Gets the quota usages for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryUsageListResultInner object
     */
    public Observable<RegistryUsageListResultInner> listUsagesAsync(String resourceGroupName, String registryName) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<RegistryUsageListResultInner>, RegistryUsageListResultInner>() {
            @Override
            public RegistryUsageListResultInner call(ServiceResponse<RegistryUsageListResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the quota usages for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryUsageListResultInner object
     */
    public Observable<ServiceResponse<RegistryUsageListResultInner>> listUsagesWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.listUsages(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryUsageListResultInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryUsageListResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryUsageListResultInner> clientResponse = listUsagesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryUsageListResultInner> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryUsageListResultInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryUsageListResultInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryPoliciesInner object if successful.
     */
    public RegistryPoliciesInner listPolicies(String resourceGroupName, String registryName) {
        return listPoliciesWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Lists the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryPoliciesInner> listPoliciesAsync(String resourceGroupName, String registryName, final ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(listPoliciesWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Lists the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryPoliciesInner object
     */
    public Observable<RegistryPoliciesInner> listPoliciesAsync(String resourceGroupName, String registryName) {
        return listPoliciesWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>() {
            @Override
            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Lists the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryPoliciesInner object
     */
    public Observable<ServiceResponse<RegistryPoliciesInner>> listPoliciesWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01";
        return service.listPolicies(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryPoliciesInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryPoliciesInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryPoliciesInner> clientResponse = listPoliciesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryPoliciesInner> listPoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryPoliciesInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryPoliciesInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryPoliciesInner object if successful.
     */
    public RegistryPoliciesInner updatePolicies(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).toBlocking().last().body();
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryPoliciesInner> updatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters, final ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters), serviceCallback);
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RegistryPoliciesInner> updatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return updatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).map(new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>() {
            @Override
            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RegistryPoliciesInner>> updatePoliciesWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryPoliciesUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryPoliciesUpdateParameters is required and cannot be null.");
        }
        Validator.validate(registryPoliciesUpdateParameters);
        final String apiVersion = "2017-10-01";
        Observable<Response<ResponseBody>> observable = service.updatePolicies(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registryPoliciesUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<RegistryPoliciesInner>() { }.getType());
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RegistryPoliciesInner object if successful.
     */
    public RegistryPoliciesInner beginUpdatePolicies(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).toBlocking().single().body();
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RegistryPoliciesInner> beginUpdatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters, final ServiceCallback<RegistryPoliciesInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters), serviceCallback);
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryPoliciesInner object
     */
    public Observable<RegistryPoliciesInner> beginUpdatePoliciesAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        return beginUpdatePoliciesWithServiceResponseAsync(resourceGroupName, registryName, registryPoliciesUpdateParameters).map(new Func1<ServiceResponse<RegistryPoliciesInner>, RegistryPoliciesInner>() {
            @Override
            public RegistryPoliciesInner call(ServiceResponse<RegistryPoliciesInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the policies for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param registryPoliciesUpdateParameters The parameters for updating policies of a container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RegistryPoliciesInner object
     */
    public Observable<ServiceResponse<RegistryPoliciesInner>> beginUpdatePoliciesWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryPoliciesInner registryPoliciesUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (registryPoliciesUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryPoliciesUpdateParameters is required and cannot be null.");
        }
        Validator.validate(registryPoliciesUpdateParameters);
        final String apiVersion = "2017-10-01";
        return service.beginUpdatePolicies(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, registryPoliciesUpdateParameters, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryPoliciesInner>>>() {
                @Override
                public Observable<ServiceResponse<RegistryPoliciesInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RegistryPoliciesInner> clientResponse = beginUpdatePoliciesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RegistryPoliciesInner> beginUpdatePoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RegistryPoliciesInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RegistryPoliciesInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RunInner object if successful.
     */
    public RunInner scheduleRun(String resourceGroupName, String registryName, RunRequest runRequest) {
        return scheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest).toBlocking().last().body();
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RunInner> scheduleRunAsync(String resourceGroupName, String registryName, RunRequest runRequest, final ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(scheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest), serviceCallback);
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RunInner> scheduleRunAsync(String resourceGroupName, String registryName, RunRequest runRequest) {
        return scheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest).map(new Func1<ServiceResponse<RunInner>, RunInner>() {
            @Override
            public RunInner call(ServiceResponse<RunInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RunInner>> scheduleRunWithServiceResponseAsync(String resourceGroupName, String registryName, RunRequest runRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runRequest == null) {
            throw new IllegalArgumentException("Parameter runRequest is required and cannot be null.");
        }
        Validator.validate(runRequest);
        final String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = service.scheduleRun(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, runRequest, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<RunInner>() { }.getType());
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RunInner object if successful.
     */
    public RunInner beginScheduleRun(String resourceGroupName, String registryName, RunRequest runRequest) {
        return beginScheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest).toBlocking().single().body();
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RunInner> beginScheduleRunAsync(String resourceGroupName, String registryName, RunRequest runRequest, final ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginScheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest), serviceCallback);
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RunInner object
     */
    public Observable<RunInner> beginScheduleRunAsync(String resourceGroupName, String registryName, RunRequest runRequest) {
        return beginScheduleRunWithServiceResponseAsync(resourceGroupName, registryName, runRequest).map(new Func1<ServiceResponse<RunInner>, RunInner>() {
            @Override
            public RunInner call(ServiceResponse<RunInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Schedules a new run based on the request parameters and add it to the run queue.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runRequest The parameters of a run that needs to scheduled.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RunInner object
     */
    public Observable<ServiceResponse<RunInner>> beginScheduleRunWithServiceResponseAsync(String resourceGroupName, String registryName, RunRequest runRequest) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runRequest == null) {
            throw new IllegalArgumentException("Parameter runRequest is required and cannot be null.");
        }
        Validator.validate(runRequest);
        final String apiVersion = "2018-09-01";
        return service.beginScheduleRun(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, runRequest, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunInner>>>() {
                @Override
                public Observable<ServiceResponse<RunInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RunInner> clientResponse = beginScheduleRunDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RunInner> beginScheduleRunDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RunInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RunInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the upload location for the user to be able to upload the source.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SourceUploadDefinitionInner object if successful.
     */
    public SourceUploadDefinitionInner getBuildSourceUploadUrl(String resourceGroupName, String registryName) {
        return getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single().body();
    }

    /**
     * Get the upload location for the user to be able to upload the source.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SourceUploadDefinitionInner> getBuildSourceUploadUrlAsync(String resourceGroupName, String registryName, final ServiceCallback<SourceUploadDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    /**
     * Get the upload location for the user to be able to upload the source.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceUploadDefinitionInner object
     */
    public Observable<SourceUploadDefinitionInner> getBuildSourceUploadUrlAsync(String resourceGroupName, String registryName) {
        return getBuildSourceUploadUrlWithServiceResponseAsync(resourceGroupName, registryName).map(new Func1<ServiceResponse<SourceUploadDefinitionInner>, SourceUploadDefinitionInner>() {
            @Override
            public SourceUploadDefinitionInner call(ServiceResponse<SourceUploadDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the upload location for the user to be able to upload the source.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceUploadDefinitionInner object
     */
    public Observable<ServiceResponse<SourceUploadDefinitionInner>> getBuildSourceUploadUrlWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        final String apiVersion = "2018-09-01";
        return service.getBuildSourceUploadUrl(this.client.subscriptionId(), resourceGroupName, registryName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceUploadDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<SourceUploadDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SourceUploadDefinitionInner> clientResponse = getBuildSourceUploadUrlDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SourceUploadDefinitionInner> getBuildSourceUploadUrlDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SourceUploadDefinitionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SourceUploadDefinitionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RegistryInner&gt; object if successful.
     */
    public PagedList<RegistryInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<RegistryInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>(response.body()) {
            @Override
            public Page<RegistryInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RegistryInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<RegistryInner>> serviceFuture, final ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<Page<RegistryInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>() {
                @Override
                public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the container registries under the specified resource group.
     *
    ServiceResponse<PageImpl<RegistryInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RegistryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RegistryInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RegistryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RegistryInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RegistryInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RegistryInner&gt; object if successful.
     */
    public PagedList<RegistryInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RegistryInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>(response.body()) {
            @Override
            public Page<RegistryInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RegistryInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<RegistryInner>> serviceFuture, final ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<Page<RegistryInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>() {
                @Override
                public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RegistryInner&gt; object
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the container registries under the specified subscription.
     *
    ServiceResponse<PageImpl<RegistryInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RegistryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RegistryInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RegistryInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RegistryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RegistryInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RegistryInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
