/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The parameters for a task run request.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("TaskRunRequest")
public class TaskRunRequest extends RunRequest {
    /**
     * The name of task against which run has to be queued.
     */
    @JsonProperty(value = "taskName", required = true)
    private String taskName;

    /**
     * The collection of overridable values that can be passed when running a
     * task.
     */
    @JsonProperty(value = "values")
    private List<SetValue> values;

    /**
     * Get the name of task against which run has to be queued.
     *
     * @return the taskName value
     */
    public String taskName() {
        return this.taskName;
    }

    /**
     * Set the name of task against which run has to be queued.
     *
     * @param taskName the taskName value to set
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * Get the collection of overridable values that can be passed when running a task.
     *
     * @return the values value
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the collection of overridable values that can be passed when running a task.
     *
     * @param values the values value to set
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

}
