/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.RunUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.RunGetLogResultInner;
import com.microsoft.azure.management.containerregistry.implementation.RunInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RunsInner {
    private RunsService service;
    private ContainerRegistryManagementClientImpl client;

    public RunsInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (RunsService)retrofit.create(RunsService.class);
        this.client = client;
    }

    public PagedList<RunInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<RunInner>((Page)response.body()){

            public Page<RunInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RunsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<RunInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(String nextPageLink) {
                return RunsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<RunInner>>, Page<RunInner>>(){

            public Page<RunInner> call(ServiceResponse<Page<RunInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<RunInner>>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(ServiceResponse<Page<RunInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RunsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        String filter = null;
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-09-01", filter, top, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RunsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RunInner> list(String resourceGroupName, String registryName, String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName, filter, top).toBlocking().single();
        return new PagedList<RunInner>((Page)response.body()){

            public Page<RunInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RunsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunInner>> listAsync(String resourceGroupName, String registryName, String filter, Integer top, ListOperationCallback<RunInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName, filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(String nextPageLink) {
                return RunsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunInner>> listAsync(String resourceGroupName, String registryName, String filter, Integer top) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName, filter, top).map((Func1)new Func1<ServiceResponse<Page<RunInner>>, Page<RunInner>>(){

            public Page<RunInner> call(ServiceResponse<Page<RunInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName, String filter, Integer top) {
        return this.listSinglePageAsync(resourceGroupName, registryName, filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<RunInner>>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(ServiceResponse<Page<RunInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RunsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listSinglePageAsync(String resourceGroupName, String registryName, String filter, Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-09-01", filter, top, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RunsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RunInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RunInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RunInner get(String resourceGroupName, String registryName, String runId) {
        return (RunInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().single()).body());
    }

    public ServiceFuture<RunInner> getAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<RunInner> getAsync(String resourceGroupName, String registryName, String runId) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<RunInner>, RunInner>(){

            public RunInner call(ServiceResponse<RunInner> response) {
                return (RunInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RunInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunInner>>>(){

            public Observable<ServiceResponse<RunInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RunsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RunInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RunInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RunInner update(String resourceGroupName, String registryName, String runId) {
        return (RunInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().last()).body());
    }

    public ServiceFuture<RunInner> updateAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<RunInner> updateAsync(String resourceGroupName, String registryName, String runId) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<RunInner>, RunInner>(){

            public RunInner call(ServiceResponse<RunInner> response) {
                return (RunInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RunInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        Object isArchiveEnabled = null;
        RunUpdateParameters runUpdateParameters = new RunUpdateParameters();
        runUpdateParameters.withIsArchiveEnabled(null);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), runUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RunInner>(){}.getType());
    }

    public RunInner update(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        return (RunInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled).toBlocking().last()).body());
    }

    public ServiceFuture<RunInner> updateAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled, ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled), serviceCallback);
    }

    public Observable<RunInner> updateAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled).map((Func1)new Func1<ServiceResponse<RunInner>, RunInner>(){

            public RunInner call(ServiceResponse<RunInner> response) {
                return (RunInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RunInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        RunUpdateParameters runUpdateParameters = new RunUpdateParameters();
        runUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), runUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RunInner>(){}.getType());
    }

    public RunInner beginUpdate(String resourceGroupName, String registryName, String runId) {
        return (RunInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().single()).body());
    }

    public ServiceFuture<RunInner> beginUpdateAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<RunInner> beginUpdateAsync(String resourceGroupName, String registryName, String runId) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<RunInner>, RunInner>(){

            public RunInner call(ServiceResponse<RunInner> response) {
                return (RunInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RunInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        Object isArchiveEnabled = null;
        RunUpdateParameters runUpdateParameters = new RunUpdateParameters();
        runUpdateParameters.withIsArchiveEnabled(null);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), runUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunInner>>>(){

            public Observable<ServiceResponse<RunInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RunsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RunInner beginUpdate(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        return (RunInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled).toBlocking().single()).body());
    }

    public ServiceFuture<RunInner> beginUpdateAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled, ServiceCallback<RunInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled), serviceCallback);
    }

    public Observable<RunInner> beginUpdateAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, runId, isArchiveEnabled).map((Func1)new Func1<ServiceResponse<RunInner>, RunInner>(){

            public RunInner call(ServiceResponse<RunInner> response) {
                return (RunInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RunInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        RunUpdateParameters runUpdateParameters = new RunUpdateParameters();
        runUpdateParameters.withIsArchiveEnabled(isArchiveEnabled);
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), runUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunInner>>>(){

            public Observable<ServiceResponse<RunInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RunsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RunInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RunInner>(){}.getType()).register(201, new TypeToken<RunInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RunGetLogResultInner getLogSasUrl(String resourceGroupName, String registryName, String runId) {
        return (RunGetLogResultInner)((ServiceResponse)this.getLogSasUrlWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().single()).body();
    }

    public ServiceFuture<RunGetLogResultInner> getLogSasUrlAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<RunGetLogResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLogSasUrlWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<RunGetLogResultInner> getLogSasUrlAsync(String resourceGroupName, String registryName, String runId) {
        return this.getLogSasUrlWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<RunGetLogResultInner>, RunGetLogResultInner>(){

            public RunGetLogResultInner call(ServiceResponse<RunGetLogResultInner> response) {
                return (RunGetLogResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RunGetLogResultInner>> getLogSasUrlWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.getLogSasUrl(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RunGetLogResultInner>>>(){

            public Observable<ServiceResponse<RunGetLogResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RunsInner.this.getLogSasUrlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RunGetLogResultInner> getLogSasUrlDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RunGetLogResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void cancel(String resourceGroupName, String registryName, String runId) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String registryName, String runId) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = this.service.cancel(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginCancel(String resourceGroupName, String registryName, String runId) {
        ((ServiceResponse)this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, runId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginCancelAsync(String resourceGroupName, String registryName, String runId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, runId), serviceCallback);
    }

    public Observable<Void> beginCancelAsync(String resourceGroupName, String registryName, String runId) {
        return this.beginCancelWithServiceResponseAsync(resourceGroupName, registryName, runId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginCancelWithServiceResponseAsync(String resourceGroupName, String registryName, String runId) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (runId == null) {
            throw new IllegalArgumentException("Parameter runId is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.beginCancel(this.client.subscriptionId(), resourceGroupName, registryName, runId, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RunsInner.this.beginCancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginCancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RunInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RunInner>((Page)response.body()){

            public Page<RunInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RunsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RunInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RunInner>> serviceFuture, ListOperationCallback<RunInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(String nextPageLink) {
                return RunsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RunInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RunInner>>, Page<RunInner>>(){

            public Page<RunInner> call(ServiceResponse<Page<RunInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RunInner>>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(ServiceResponse<Page<RunInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RunsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RunInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RunInner>>>>(){

            public Observable<ServiceResponse<Page<RunInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RunsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RunInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RunInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RunsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Query(value="$top") Integer var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body RunUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body RunUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs getLogSasUrl"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}/listLogSasUrl")
        public Observable<Response<ResponseBody>> getLogSasUrl(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs beginCancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/runs/{runId}/cancel")
        public Observable<Response<ResponseBody>> beginCancel(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="runId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Runs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

