/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The login password for the container registry.
 */
public class RegistryPassword {
    /**
     * The password name. Possible values include: 'password', 'password2'.
     */
    @JsonProperty(value = "name")
    private PasswordName name;

    /**
     * The password value.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the password name. Possible values include: 'password', 'password2'.
     *
     * @return the name value
     */
    public PasswordName name() {
        return this.name;
    }

    /**
     * Set the password name. Possible values include: 'password', 'password2'.
     *
     * @param name the name value to set
     * @return the RegistryPassword object itself.
     */
    public RegistryPassword withName(PasswordName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the password value.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the password value.
     *
     * @param value the value value to set
     * @return the RegistryPassword object itself.
     */
    public RegistryPassword withValue(String value) {
        this.value = value;
        return this;
    }

}
