/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerregistry;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for OS.
 */
public final class OS extends ExpandableStringEnum<OS> {
    /** Static value Windows for OS. */
    public static final OS WINDOWS = fromString("Windows");

    /** Static value Linux for OS. */
    public static final OS LINUX = fromString("Linux");

    /**
     * Creates or finds a OS from its string representation.
     * @param name a name to look for
     * @return the corresponding OS
     */
    @JsonCreator
    public static OS fromString(String name) {
        return fromString(name, OS.class);
    }

    /**
     * @return known OS values
     */
    public static Collection<OS> values() {
        return values(OS.class);
    }
}
